/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.syncs.ftp;

import com.bcxin.runtime.domain.syncs.dtos.FtpConfigInfoDto;
import com.bcxin.runtime.domain.syncs.enums.UploadStatus;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.SocketException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncFtpUtil {
    protected static final Logger logger = LoggerFactory.getLogger(SyncFtpUtil.class);

    public static UploadStatus upload(String local, String remote, FtpConfigInfoDto ftpConfigInfoDto) throws Exception {
        UploadStatus result;
        FTPFile[] files;
        FTPClient ftpClient = SyncFtpUtil.getFTPClient(ftpConfigInfoDto.getHost(), ftpConfigInfoDto.getUserName(), ftpConfigInfoDto.getPassword(), ftpConfigInfoDto.getPort());
        ftpClient.enterLocalPassiveMode();
        ftpClient.setFileType(2);
        ftpClient.setControlEncoding("GBK");
        String remoteFileName = remote;
        if (remote.contains("/")) {
            remoteFileName = remote.substring(remote.lastIndexOf("/") + 1);
            if (SyncFtpUtil.CreateDirecroty(remote, ftpClient) == UploadStatus.Create_Directory_Fail) {
                return UploadStatus.Create_Directory_Fail;
            }
        }
        if ((files = ftpClient.listFiles(new String(remoteFileName.getBytes("GBK"), "iso-8859-1"))).length == 1) {
            File f;
            long localSize;
            long remoteSize = files[0].getSize();
            if (remoteSize == (localSize = (f = new File(local)).length())) {
                return UploadStatus.File_Exits;
            }
            if (remoteSize > localSize && localSize > 0L) {
                return UploadStatus.Remote_Bigger_Local;
            }
            if (remoteSize > localSize && localSize == 0L) {
                return UploadStatus.File_Not_Exits;
            }
            result = SyncFtpUtil.uploadFile(remoteFileName, f, ftpClient, remoteSize);
            if (result == UploadStatus.Upload_From_Break_Failed) {
                if (!ftpClient.deleteFile(remoteFileName)) {
                    return UploadStatus.Delete_Remote_Faild;
                }
                result = SyncFtpUtil.uploadFile(remoteFileName, f, ftpClient, 0L);
            }
        } else {
            result = SyncFtpUtil.uploadFile(remoteFileName, new File(local), ftpClient, 0L);
        }
        return result;
    }

    public static UploadStatus uploadFile(String remoteFile, File localFile, FTPClient ftpClient, long remoteSize) throws IOException {
        int c;
        long step = localFile.length() / 100L;
        long process = 0L;
        long localreadbytes = 0L;
        RandomAccessFile raf = new RandomAccessFile(localFile, "r");
        OutputStream out = ftpClient.appendFileStream(new String(remoteFile.getBytes("GBK"), "iso-8859-1"));
        if (remoteSize > 0L) {
            ftpClient.setRestartOffset(remoteSize);
            process = remoteSize / step;
            raf.seek(remoteSize);
            localreadbytes = remoteSize;
        }
        byte[] bytes = new byte[1024];
        while ((c = raf.read(bytes)) != -1) {
            out.write(bytes, 0, c);
            if ((localreadbytes += (long)c) / step == process) continue;
            process = localreadbytes / step;
            System.out.println("\u4e0a\u4f20\u8fdb\u5ea6:" + process);
        }
        out.flush();
        raf.close();
        out.close();
        boolean result = ftpClient.completePendingCommand();
        UploadStatus status = remoteSize > 0L ? (result ? UploadStatus.Upload_From_Break_Success : UploadStatus.Upload_From_Break_Failed) : (result ? UploadStatus.Upload_New_File_Success : UploadStatus.Upload_New_File_Failed);
        return status;
    }

    public static FTPClient getFTPClient(String ftpHost, String ftpUserName, String ftpPassword, int ftpPort) {
        FTPClient ftpClient = new FTPClient();
        try {
            ftpClient = new FTPClient();
            ftpClient.connect(ftpHost, ftpPort);
            ftpClient.login(ftpUserName, ftpPassword);
            if (!FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
                ftpClient.disconnect();
            } else {
                logger.info("FTP\u8fde\u63a5\u6210\u529f\u3002");
            }
        }
        catch (SocketException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return ftpClient;
    }

    public static UploadStatus CreateDirecroty(String remote, FTPClient ftpClient) throws IOException {
        UploadStatus status;
        block2: {
            status = UploadStatus.Create_Directory_Success;
            String directory = remote.substring(0, remote.lastIndexOf("/") + 1);
            if (directory.equalsIgnoreCase("/") || ftpClient.changeWorkingDirectory(new String(directory.getBytes("GBK"), "iso-8859-1"))) break block2;
            int start = 0;
            int end = 0;
            start = directory.startsWith("/") ? 1 : 0;
            end = directory.indexOf("/", start);
            do {
                String subDirectory;
                if (ftpClient.changeWorkingDirectory(subDirectory = new String(remote.substring(start, end).getBytes("GBK"), "iso-8859-1"))) continue;
                if (ftpClient.makeDirectory(subDirectory)) {
                    ftpClient.changeWorkingDirectory(subDirectory);
                    continue;
                }
                System.out.println("\u521b\u5efa\u76ee\u5f55\u5931\u8d25");
                return UploadStatus.Create_Directory_Fail;
            } while ((end = directory.indexOf("/", start = end + 1)) > start);
        }
        return status;
    }
}

