/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.syncs.ftp;

import cn.hutool.core.util.StrUtil;
import com.bcxin.runtime.domain.syncs.enums.UploadStatus;
import com.bcxin.runtime.domain.syncs.ftp.BcxinFtpClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.file.Paths;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtils {
    protected static Logger logger = LoggerFactory.getLogger(FtpUtils.class);

    public static FTPClient getFTPClient(String ftpHost, String ftpUserName, String ftpPassword, int ftpPort) {
        FTPClient ftpClient = new FTPClient();
        try {
            ftpClient = new FTPClient();
            ftpClient.connect(ftpHost, ftpPort);
            ftpClient.login(ftpUserName, ftpPassword);
            if (!FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
                logger.info("\u672a\u8fde\u63a5\u5230FTP\uff0c\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002");
                ftpClient.disconnect();
            } else {
                logger.info("FTP\u8fde\u63a5\u6210\u529f\u3002");
            }
        }
        catch (SocketException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return ftpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream downloadFile(String ftpHost, String ftpUserName, String ftpPassword, int ftpPort, String ftpPath, String fileName) {
        FTPClient ftpClient = null;
        InputStream is = null;
        try {
            ftpClient = FtpUtils.getFTPClient(ftpHost, ftpUserName, ftpPassword, ftpPort);
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.setFileType(2);
            ftpClient.enterLocalPassiveMode();
            ftpClient.changeWorkingDirectory(ftpPath);
            is = ftpClient.retrieveFileStream(fileName);
        }
        catch (FileNotFoundException e) {
            logger.error("\u6ca1\u6709\u627e\u5230" + ftpPath + "\u6587\u4ef6");
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SocketException e) {
            logger.error("\u8fde\u63a5FTP\u5931\u8d25.");
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\u3002");
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (ftpClient != null) {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFile(String ftpHost, String ftpUserName, String ftpPassword, int ftpPort, String ftpPath, String localPath, String fileName) {
        FTPClient ftpClient = null;
        OutputStream os = null;
        File dir = new File(localPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File localFile = new File(localPath + fileName);
        try {
            ftpClient = FtpUtils.getFTPClient(ftpHost, ftpUserName, ftpPassword, ftpPort);
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.setFileType(2);
            FTPClientConfig conf = new FTPClientConfig("UNIX");
            ftpClient.configure(conf);
            ftpClient.setRemoteVerificationEnabled(false);
            ftpClient.enterLocalPassiveMode();
            ftpClient.changeWorkingDirectory(ftpPath);
            try (InputStream initialStream = ftpClient.retrieveFileStream(new String(fileName.getBytes("UTF-8"), "UTF-8"));
                 FileOutputStream outStream = new FileOutputStream(localFile);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = initialStream.read(buffer)) != -1) {
                    ((OutputStream)outStream).write(buffer, 0, bytesRead);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6ca1\u6709\u627e\u5230" + ftpPath + "\u6587\u4ef6");
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SocketException e) {
            logger.error("\u8fde\u63a5FTP\u5931\u8d25.");
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\u3002");
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
            }
            try {
                if (ftpClient != null && ftpClient.isConnected()) {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uploadFile(String ftpHost, String ftpUserName, String ftpPassword, int ftpPort, String ftpPath, String fileName, InputStream input) {
        FTPClient ftp = null;
        try {
            ftp = FtpUtils.getFTPClient(ftpHost, ftpUserName, ftpPassword, ftpPort);
            FtpUtils.changeDir(ftp, ftpPath);
            logger.error("\u5f53\u524d\u76ee\u5f55\uff1a" + ftp.printWorkingDirectory());
            ftp.setFileType(2);
            if (ftp.storeFile(fileName, input)) {
                logger.error(fileName + "\u4e0a\u4f20\u5230" + ftpPath + "\u6210\u529f");
            } else {
                logger.error(fileName + "\u4e0a\u4f20\u5230" + ftpPath + "\u5931\u8d25");
                fileName = new String(fileName.getBytes("GBK"), "iso-8859-1");
                if (ftp.storeFile(fileName, input)) {
                    logger.error(fileName + "\u4e0a\u4f20\u5230" + ftpPath + "\u6210\u529f");
                } else {
                    logger.error(fileName + "\u4e0a\u4f20\u5230" + ftpPath + "\u5931\u8d25");
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            try {
                if (ftp != null) {
                    ftp.logout();
                    ftp.disconnect();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadFile(String ftpHost, String ftpUserName, String ftpPassword, int ftpPort, String pathFile, InputStream input) {
        boolean result = false;
        FTPClient ftp = null;
        try {
            String ftpPath = pathFile.substring(0, pathFile.lastIndexOf("/"));
            String fileName = pathFile.substring(pathFile.lastIndexOf("/") + 1);
            ftp = FtpUtils.getFTPClient(ftpHost, ftpUserName, ftpPassword, ftpPort);
            ftp.setFileType(2);
            logger.error("\u5f53\u524dFTP\u76ee\u5f55\uff1a" + ftp.printWorkingDirectory());
            if (ftp.storeFile(pathFile, input)) {
                logger.error(pathFile + "\u4e0a\u4f20\u6210\u529f");
            }
            FtpUtils.changeDir(ftp, ftpPath);
            logger.error("\u5f53\u524dFTP\u76ee\u5f55\uff1a" + ftp.printWorkingDirectory());
            if (ftp.storeFile(fileName, input)) {
                result = true;
                logger.error(fileName + "\u4e0a\u4f20\u6210\u529f");
            } else {
                logger.error(fileName + "\u4e0a\u4f20\u5931\u8d25");
                fileName = new String(fileName.getBytes("GBK"), "iso-8859-1");
                if (ftp.storeFile(fileName, input)) {
                    logger.error(fileName + "\u4e0a\u4f20\u6210\u529f");
                    result = true;
                } else {
                    logger.error(fileName + "\u4e0a\u4f20\u5931\u8d25");
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            try {
                if (ftp != null) {
                    ftp.logout();
                    ftp.disconnect();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static void changeDir(FTPClient ftpClient, String dirPath) {
        try {
            for (String s : dirPath.split("/")) {
                if (StrUtil.isEmpty((CharSequence)s)) continue;
                if (!ftpClient.changeWorkingDirectory(s)) {
                    logger.error("\u8fdb\u5165\u76ee\u5f55\u5931\u8d25\uff1a" + s);
                    if (!ftpClient.makeDirectory(s)) {
                        logger.error("\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff1a" + s);
                    } else {
                        logger.error("\u521b\u5efa\u76ee\u5f55\u6210\u529f\uff1a" + s);
                    }
                    if (!ftpClient.changeWorkingDirectory(s)) {
                        logger.error("\u8fdb\u5165\u76ee\u5f55\u5931\u8d25\uff1a" + s);
                        continue;
                    }
                    logger.error("\u8fdb\u5165\u76ee\u5f55\u6210\u529f\uff1a" + s);
                    continue;
                }
                logger.error("\u8fdb\u5165\u76ee\u5f55\u6210\u529f\uff1a" + s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static UploadStatus bcxUploadFile(String ftpHost, String ftpUserName, String ftpPassword, int ftpPort, String pathFile, String localPath) throws Exception {
        BcxinFtpClient ftpClient = null;
        FileInputStream input = null;
        try {
            boolean existFlag;
            String filePath;
            String fileDir;
            File file = new File(localPath);
            if (!file.exists()) {
                UploadStatus uploadStatus = UploadStatus.File_Not_Exits;
                return uploadStatus;
            }
            ftpClient = new BcxinFtpClient();
            ftpClient.connect(ftpHost, ftpUserName, ftpPassword, ftpPort);
            String ftpPath = pathFile.substring(0, pathFile.lastIndexOf("/") + 1);
            ftpPath = new String(ftpPath.getBytes("UTF-8"), "iso-8859-1");
            String fileName = pathFile.substring(pathFile.lastIndexOf("/") + 1);
            fileName = new String(fileName.getBytes("UTF-8"), "iso-8859-1");
            boolean isDir = ftpClient.isARemoteDirectory(ftpPath);
            if (!isDir) {
                boolean createDirectoryFlag = ftpClient.createDirectory(ftpPath);
                if (!createDirectoryFlag) {
                    logger.error("\u76ee\u5f55\u521b\u5efa\u5931\u8d25\uff1a[{}]", (Object)ftpPath);
                    UploadStatus uploadStatus = UploadStatus.Create_Directory_Fail;
                    return uploadStatus;
                }
                logger.debug("\u76ee\u5f55\u521b\u5efa\u6210\u529f\uff1a[{}]", (Object)ftpPath);
            }
            if (!ftpClient.isARemoteDirectory(fileDir = Paths.get(filePath = ftpPath + fileName, new String[0]).getParent().toString().replace("\\", "/"))) {
                boolean createDirectoryFlag = ftpClient.createDirectory(fileDir);
                if (!createDirectoryFlag) {
                    logger.error("\u76ee\u5f55\u521b\u5efa\u5931\u8d25\uff1a[{}]", (Object)ftpPath);
                    UploadStatus uploadStatus = UploadStatus.Create_Directory_Fail;
                    return uploadStatus;
                }
                logger.debug("\u76ee\u5f55\u521b\u5efa\u6210\u529f\uff1a[{}]", (Object)ftpPath);
            }
            if (existFlag = FtpUtils.existFile(filePath = filePath.replace("\\", "/"), ftpClient, file)) {
                UploadStatus uploadStatus = UploadStatus.File_Exits;
                return uploadStatus;
            }
            input = new FileInputStream(file);
            boolean result = ftpClient.uploadFile(input, filePath);
            if (result) {
                UploadStatus uploadStatus = UploadStatus.Upload_New_File_Success;
                return uploadStatus;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (ftpClient != null) {
                try {
                    ftpClient.disconnect();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        return UploadStatus.Upload_New_File_Failed;
    }

    public static boolean checkUrlFileExists(InputStream inputStream) {
        boolean flag = false;
        try {
            byte[] bytes = new byte[1024];
            if (inputStream.read(bytes) != -1) {
                flag = true;
            }
            return flag;
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5\u6446\u6e21\u670d\u52a1\u6587\u4ef6\u662f\u5426\u5b58\u5728\u5f02\u5e38", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean existFile(String ftpPath, BcxinFtpClient ftpClient, File localFile) {
        boolean flag = false;
        try {
            FTPFile[] ftpFileArr = ftpClient.getClient().listFiles(ftpPath);
            if (ftpFileArr.length > 0) {
                long remoteSize = ftpFileArr[0].getSize();
                if (remoteSize >= localFile.length()) {
                    flag = true;
                } else {
                    ftpClient.deleteFile(ftpPath);
                }
            }
        }
        catch (Exception e) {
            logger.debug("\u5224\u65adftp\u670d\u52a1\u5668\u6587\u4ef6\u662f\u5426\u5b58\u5728\u51fa\u9519\uff1a[{}]", (Object)ftpPath);
        }
        return flag;
    }

    public static long getFileLength(String ftpPath, BcxinFtpClient ftpClient) {
        long length = 0L;
        try {
            FTPFile[] files = ftpClient.getClient().listFiles(ftpPath);
            if (files != null && files.length > 0) {
                length = files[0].getSize();
            }
        }
        catch (Exception e) {
            logger.debug("\u83b7\u53d6ftp\u670d\u52a1\u5668\u6587\u4ef6\u5927\u5c0f\u51fa\u9519\uff1a[{}]", (Object)ftpPath);
        }
        return length;
    }
}

