/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.syncs.entities;

import com.bcxin.runtime.domain.syncs.entities.DataSyncMapEntity;
import com.bcxin.runtime.domain.syncs.enums.ProcessedStatus;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="sync_data_request_logs")
public class DataSyncLogEntity
extends EntityBase<String>
implements IAggregate {
    @Id
    @Column(length=100, nullable=false)
    private String id;
    @Column(name="sync_queue_id", nullable=false)
    private String syncQueueId;
    @Column(length=5000)
    private String data;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", nullable=false)
    private Date createdTime;
    @Column(length=5000)
    private String result;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(nullable=false)
    private ProcessedStatus status;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sync_data_map_id")
    private DataSyncMapEntity dataMapSync;

    protected DataSyncLogEntity() {
    }

    protected DataSyncLogEntity(DataSyncMapEntity dataMapSync, String syncQueueId, String data, ProcessedStatus status, String result) {
        this.setDataMapSync(dataMapSync);
        this.setSyncQueueId(syncQueueId);
        this.setData(data);
        this.setStatus(status);
        this.setResult(result);
        this.setId(String.format("%s_%s", new Date().getTime(), UUID.randomUUID()));
        this.setCreatedTime(new Date());
    }

    public static DataSyncLogEntity create(DataSyncMapEntity dataMapSync, String syncQueueId, String data, ProcessedStatus status, String result) {
        return new DataSyncLogEntity(dataMapSync, syncQueueId, data, status, result);
    }

    public String getId() {
        return this.id;
    }

    public String getSyncQueueId() {
        return this.syncQueueId;
    }

    public String getData() {
        return this.data;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public String getResult() {
        return this.result;
    }

    public ProcessedStatus getStatus() {
        return this.status;
    }

    public DataSyncMapEntity getDataMapSync() {
        return this.dataMapSync;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSyncQueueId(String syncQueueId) {
        this.syncQueueId = syncQueueId;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setStatus(ProcessedStatus status) {
        this.status = status;
    }

    public void setDataMapSync(DataSyncMapEntity dataMapSync) {
        this.dataMapSync = dataMapSync;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSyncLogEntity)) {
            return false;
        }
        DataSyncLogEntity other = (DataSyncLogEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$syncQueueId = this.getSyncQueueId();
        String other$syncQueueId = other.getSyncQueueId();
        if (this$syncQueueId == null ? other$syncQueueId != null : !this$syncQueueId.equals(other$syncQueueId)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Date this$createdTime = this.getCreatedTime();
        Date other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        ProcessedStatus this$status = this.getStatus();
        ProcessedStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        DataSyncMapEntity this$dataMapSync = this.getDataMapSync();
        DataSyncMapEntity other$dataMapSync = other.getDataMapSync();
        return !(this$dataMapSync == null ? other$dataMapSync != null : !((Object)((Object)this$dataMapSync)).equals((Object)other$dataMapSync));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSyncLogEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $syncQueueId = this.getSyncQueueId();
        result = result * 59 + ($syncQueueId == null ? 43 : $syncQueueId.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Date $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        ProcessedStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        DataSyncMapEntity $dataMapSync = this.getDataMapSync();
        result = result * 59 + ($dataMapSync == null ? 43 : ((Object)((Object)$dataMapSync)).hashCode());
        return result;
    }

    public String toString() {
        return "DataSyncLogEntity(id=" + this.getId() + ", syncQueueId=" + this.getSyncQueueId() + ", data=" + this.getData() + ", createdTime=" + this.getCreatedTime() + ", result=" + this.getResult() + ", status=" + (Object)((Object)this.getStatus()) + ", dataMapSync=" + (Object)((Object)this.getDataMapSync()) + ")";
    }
}

