/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.syncs.dtos;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.bcxin.runtime.domain.constants.FieldNames;
import com.bcxin.runtime.domain.syncs.enums.ProcessedStatus;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetDto {
    private String tableName;
    private String sql;
    private Date fetchedModifiedTime;
    private Date exportedTime;
    private int totalCount;
    private Collection<Column> columns;
    private Collection<Row> rows;
    private Collection<String> deletedIds;

    public static DataSetDto create(String tableName, int totalCount, Collection<Column> columns, Collection<Row> rows) {
        DataSetDto record = new DataSetDto();
        record.setTableName(tableName);
        record.setTotalCount(totalCount);
        record.setColumns(columns);
        record.setRows(rows);
        return record;
    }

    public void markInfo(String sql, Date fetchedModifiedTime, Date exportedTime) {
        this.setSql(sql);
        this.setExportedTime(exportedTime);
        this.setFetchedModifiedTime(fetchedModifiedTime);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSql() {
        return this.sql;
    }

    public Date getFetchedModifiedTime() {
        return this.fetchedModifiedTime;
    }

    public Date getExportedTime() {
        return this.exportedTime;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public Collection<Column> getColumns() {
        return this.columns;
    }

    public Collection<Row> getRows() {
        return this.rows;
    }

    public Collection<String> getDeletedIds() {
        return this.deletedIds;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setFetchedModifiedTime(Date fetchedModifiedTime) {
        this.fetchedModifiedTime = fetchedModifiedTime;
    }

    public void setExportedTime(Date exportedTime) {
        this.exportedTime = exportedTime;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void setColumns(Collection<Column> columns) {
        this.columns = columns;
    }

    public void setRows(Collection<Row> rows) {
        this.rows = rows;
    }

    public void setDeletedIds(Collection<String> deletedIds) {
        this.deletedIds = deletedIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSetDto)) {
            return false;
        }
        DataSetDto other = (DataSetDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        Date this$fetchedModifiedTime = this.getFetchedModifiedTime();
        Date other$fetchedModifiedTime = other.getFetchedModifiedTime();
        if (this$fetchedModifiedTime == null ? other$fetchedModifiedTime != null : !((Object)this$fetchedModifiedTime).equals(other$fetchedModifiedTime)) {
            return false;
        }
        Date this$exportedTime = this.getExportedTime();
        Date other$exportedTime = other.getExportedTime();
        if (this$exportedTime == null ? other$exportedTime != null : !((Object)this$exportedTime).equals(other$exportedTime)) {
            return false;
        }
        Collection<Column> this$columns = this.getColumns();
        Collection<Column> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Collection<Row> this$rows = this.getRows();
        Collection<Row> other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        Collection<String> this$deletedIds = this.getDeletedIds();
        Collection<String> other$deletedIds = other.getDeletedIds();
        return !(this$deletedIds == null ? other$deletedIds != null : !((Object)this$deletedIds).equals(other$deletedIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSetDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalCount();
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        Date $fetchedModifiedTime = this.getFetchedModifiedTime();
        result = result * 59 + ($fetchedModifiedTime == null ? 43 : ((Object)$fetchedModifiedTime).hashCode());
        Date $exportedTime = this.getExportedTime();
        result = result * 59 + ($exportedTime == null ? 43 : ((Object)$exportedTime).hashCode());
        Collection<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Collection<Row> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        Collection<String> $deletedIds = this.getDeletedIds();
        result = result * 59 + ($deletedIds == null ? 43 : ((Object)$deletedIds).hashCode());
        return result;
    }

    public String toString() {
        return "DataSetDto(tableName=" + this.getTableName() + ", sql=" + this.getSql() + ", fetchedModifiedTime=" + this.getFetchedModifiedTime() + ", exportedTime=" + this.getExportedTime() + ", totalCount=" + this.getTotalCount() + ", columns=" + this.getColumns() + ", rows=" + this.getRows() + ", deletedIds=" + this.getDeletedIds() + ")";
    }

    public static class FieldValue {
        private static final Logger logger = LoggerFactory.getLogger(FieldValue.class);
        private String name;
        private Object value;
        private String originalValue;
        private Collection<FieldNames.PathOption> pathOptions;

        @JSONField(serialize=false)
        public boolean getIsFileValue() {
            return FieldNames.isFile(this.getName());
        }

        @JSONField(serialize=false)
        public boolean isValidFile() {
            if (this.getIsFileValue()) {
                boolean flag;
                boolean bl = flag = this.getValue() != null && !"".equalsIgnoreCase(String.valueOf(this.getValue())) && !"null".equalsIgnoreCase(String.valueOf(this.getValue()));
                if (!flag) {
                    return false;
                }
                try {
                    return String.valueOf(this.getValue()).contains("[") && String.valueOf(this.getValue()).contains("]") && String.valueOf(this.getValue()).contains("{") && String.valueOf(this.getValue()).contains("}");
                }
                catch (Exception ex) {
                    System.err.println(String.format("\u5b57\u6bb5\u4fe1\u606f:%s", this.getName()));
                    ex.printStackTrace();
                }
            }
            return false;
        }

        public static FieldValue create(String sitePrefix, String domainId, String rowId, String name, Object value) {
            FieldValue fieldValue = new FieldValue();
            fieldValue.setName(name);
            Object formattedValue = value;
            String originalValue = String.valueOf(value);
            if (fieldValue.getIsFileValue() && !StringUtils.isEmpty((CharSequence)originalValue) && !"null".equalsIgnoreCase(originalValue)) {
                try {
                    originalValue = URLDecoder.decode(originalValue, "UTF-8");
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u8868\u6587\u4ef6\u76f8\u5173\u5b57\u6bb5\u8f6c\u7801\u5f02\u5e38\uff0c\u6587\u4ef6\u540d\u4e3a\uff1a{}", (Object)name, (Object)e);
                }
                formattedValue = FieldNames.formattedFileValue(sitePrefix, domainId, rowId, originalValue);
                if (formattedValue != null && formattedValue.toString().contains("[")) {
                    try {
                        List pathOptions = JSON.parseArray((String)((String)formattedValue), FieldNames.PathOption.class);
                        fieldValue.setPathOptions(pathOptions);
                    }
                    catch (Exception ex) {
                        logger.error(String.format("\u521d\u59cb\u5316\u5b57\u6bb5: %s, \u5c1d\u8bd5\u83b7\u53d6\u6587\u4ef6\u503c\u4fe1\u606f\u62a5\u9519", name), (Throwable)ex);
                        ex.printStackTrace();
                    }
                }
            }
            fieldValue.setOriginalValue(originalValue);
            fieldValue.setValue(formattedValue);
            return fieldValue;
        }

        @JSONField(serialize=false)
        public Collection<String> getFileUrls() {
            if (!this.isValidFile() || this.getPathOptions() == null) {
                return null;
            }
            return this.getPathOptions().stream().map(ix -> ix.getOriginalPath()).collect(Collectors.toList());
        }

        @JSONField(serialize=false)
        public Collection<String> getFileIds() {
            if (!this.isValidFile() || this.getPathOptions() == null) {
                return null;
            }
            return this.getPathOptions().stream().map(ix -> ix.getUid()).collect(Collectors.toList());
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public String getOriginalValue() {
            return this.originalValue;
        }

        public Collection<FieldNames.PathOption> getPathOptions() {
            return this.pathOptions;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void setOriginalValue(String originalValue) {
            this.originalValue = originalValue;
        }

        public void setPathOptions(Collection<FieldNames.PathOption> pathOptions) {
            this.pathOptions = pathOptions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldValue)) {
                return false;
            }
            FieldValue other = (FieldValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$originalValue = this.getOriginalValue();
            String other$originalValue = other.getOriginalValue();
            if (this$originalValue == null ? other$originalValue != null : !this$originalValue.equals(other$originalValue)) {
                return false;
            }
            Collection<FieldNames.PathOption> this$pathOptions = this.getPathOptions();
            Collection<FieldNames.PathOption> other$pathOptions = other.getPathOptions();
            return !(this$pathOptions == null ? other$pathOptions != null : !((Object)this$pathOptions).equals(other$pathOptions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $originalValue = this.getOriginalValue();
            result = result * 59 + ($originalValue == null ? 43 : $originalValue.hashCode());
            Collection<FieldNames.PathOption> $pathOptions = this.getPathOptions();
            result = result * 59 + ($pathOptions == null ? 43 : ((Object)$pathOptions).hashCode());
            return result;
        }

        public String toString() {
            return "DataSetDto.FieldValue(name=" + this.getName() + ", value=" + this.getValue() + ", originalValue=" + this.getOriginalValue() + ", pathOptions=" + this.getPathOptions() + ")";
        }
    }

    public static class Row {
        private static final String DOMAIN_ID = "DOMAIN_ID";
        private Object id;
        private Map<String, Object> parameters;
        private Collection<FieldValue> fieldValues;
        private ProcessedStatus status;
        private Date processedTime;
        private boolean convertPK = false;

        public static Row create(Object id, Collection<FieldValue> fieldValues) {
            Row rw = new Row();
            rw.setId(id);
            rw.setFieldValues(fieldValues);
            return rw;
        }

        public Object getParameterValue(String key) {
            if (this.getParameters() == null) {
                return null;
            }
            if (!this.getParameters().containsKey(key)) {
                return null;
            }
            return this.getParameters().get(key);
        }

        public String getDomainId() {
            Object value = this.getParameterValue(DOMAIN_ID);
            if (value == null) {
                return null;
            }
            return String.valueOf(value);
        }

        public void setDomainId(String value) {
            this.addParameter(DOMAIN_ID, value);
        }

        public void addParameter(String key, Object value) {
            Map<String, Object> pm = this.getParameters();
            if (pm == null) {
                pm = new HashMap<String, Object>();
                this.setParameters(pm);
            }
            pm.put(key, value);
        }

        public void changeStatus(ProcessedStatus status) {
            this.setStatus(status);
            this.setProcessedTime(new Date());
        }

        public Object getId() {
            return this.id;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public Collection<FieldValue> getFieldValues() {
            return this.fieldValues;
        }

        public ProcessedStatus getStatus() {
            return this.status;
        }

        public Date getProcessedTime() {
            return this.processedTime;
        }

        public boolean isConvertPK() {
            return this.convertPK;
        }

        public void setId(Object id) {
            this.id = id;
        }

        public void setParameters(Map<String, Object> parameters) {
            this.parameters = parameters;
        }

        public void setFieldValues(Collection<FieldValue> fieldValues) {
            this.fieldValues = fieldValues;
        }

        public void setStatus(ProcessedStatus status) {
            this.status = status;
        }

        public void setProcessedTime(Date processedTime) {
            this.processedTime = processedTime;
        }

        public void setConvertPK(boolean convertPK) {
            this.convertPK = convertPK;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isConvertPK() != other.isConvertPK()) {
                return false;
            }
            Object this$id = this.getId();
            Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Map<String, Object> this$parameters = this.getParameters();
            Map<String, Object> other$parameters = other.getParameters();
            if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
                return false;
            }
            Collection<FieldValue> this$fieldValues = this.getFieldValues();
            Collection<FieldValue> other$fieldValues = other.getFieldValues();
            if (this$fieldValues == null ? other$fieldValues != null : !((Object)this$fieldValues).equals(other$fieldValues)) {
                return false;
            }
            ProcessedStatus this$status = this.getStatus();
            ProcessedStatus other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            Date this$processedTime = this.getProcessedTime();
            Date other$processedTime = other.getProcessedTime();
            return !(this$processedTime == null ? other$processedTime != null : !((Object)this$processedTime).equals(other$processedTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Row;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isConvertPK() ? 79 : 97);
            Object $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Map<String, Object> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            Collection<FieldValue> $fieldValues = this.getFieldValues();
            result = result * 59 + ($fieldValues == null ? 43 : ((Object)$fieldValues).hashCode());
            ProcessedStatus $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            Date $processedTime = this.getProcessedTime();
            result = result * 59 + ($processedTime == null ? 43 : ((Object)$processedTime).hashCode());
            return result;
        }

        public String toString() {
            return "DataSetDto.Row(id=" + this.getId() + ", parameters=" + this.getParameters() + ", fieldValues=" + this.getFieldValues() + ", status=" + (Object)((Object)this.getStatus()) + ", processedTime=" + this.getProcessedTime() + ", convertPK=" + this.isConvertPK() + ")";
        }
    }

    public static class Column {
        private boolean isFile;
        private String name;

        public static Column create(String name) {
            Column column = new Column();
            if ("AttachmentUploadField".equalsIgnoreCase(name) || "imageUploadValue".equals(name)) {
                column.setFile(true);
            }
            column.setName(name);
            return column;
        }

        public boolean isId() {
            return "id".equalsIgnoreCase(this.getName());
        }

        public boolean isDomainId() {
            return "DOMAINID".equalsIgnoreCase(this.getName().replace("_", ""));
        }

        public boolean isFile() {
            return this.isFile;
        }

        public String getName() {
            return this.name;
        }

        public void setFile(boolean isFile) {
            this.isFile = isFile;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Column)) {
                return false;
            }
            Column other = (Column)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isFile() != other.isFile()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Column;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFile() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "DataSetDto.Column(isFile=" + this.isFile() + ", name=" + this.getName() + ")";
        }
    }
}

