/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.snapshoots;

import com.bcxin.runtime.domain.syncs.commands.CreateDataSyncCommand;
import com.bcxin.runtime.domain.syncs.dtos.DataSetDto;
import java.util.Collection;
import java.util.stream.Collectors;

public class SyncDataFileSnapshot {
    private Collection<DataSet> dataSets;
    private String filePaths;

    public SyncDataFileSnapshot() {
    }

    public SyncDataFileSnapshot(Collection<DataSet> dataSets, String filePaths) {
        this.setDataSets(dataSets);
        this.setFilePaths(filePaths);
    }

    public static SyncDataFileSnapshot create(Collection<DataSet> dataSets, String filePaths) {
        return new SyncDataFileSnapshot(dataSets, filePaths);
    }

    public static SyncDataFileSnapshot create(CreateDataSyncCommand command) {
        Collection dataSets = command.getDataSets().stream().map(ii -> DataSet.create(ii.getId(), ii.getMapKey(), ii.getRows(), ii.getDeletedIds())).collect(Collectors.toList());
        return SyncDataFileSnapshot.create(dataSets, command.getFilePaths());
    }

    public Collection<DataSet> getDataSets() {
        return this.dataSets;
    }

    public String getFilePaths() {
        return this.filePaths;
    }

    public void setDataSets(Collection<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    public void setFilePaths(String filePaths) {
        this.filePaths = filePaths;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SyncDataFileSnapshot)) {
            return false;
        }
        SyncDataFileSnapshot other = (SyncDataFileSnapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<DataSet> this$dataSets = this.getDataSets();
        Collection<DataSet> other$dataSets = other.getDataSets();
        if (this$dataSets == null ? other$dataSets != null : !((Object)this$dataSets).equals(other$dataSets)) {
            return false;
        }
        String this$filePaths = this.getFilePaths();
        String other$filePaths = other.getFilePaths();
        return !(this$filePaths == null ? other$filePaths != null : !this$filePaths.equals(other$filePaths));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SyncDataFileSnapshot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<DataSet> $dataSets = this.getDataSets();
        result = result * 59 + ($dataSets == null ? 43 : ((Object)$dataSets).hashCode());
        String $filePaths = this.getFilePaths();
        result = result * 59 + ($filePaths == null ? 43 : $filePaths.hashCode());
        return result;
    }

    public String toString() {
        return "SyncDataFileSnapshot(dataSets=" + this.getDataSets() + ", filePaths=" + this.getFilePaths() + ")";
    }

    public static class DataSet {
        private String id;
        private String mapKey;
        private Collection<DataSetDto.Row> rows;
        private Collection<String> deletedIds;

        public DataSet() {
        }

        public DataSet(String id, String mapKey, Collection<DataSetDto.Row> rows, Collection<String> deletedIds) {
            this.id = id;
            this.mapKey = mapKey;
            this.rows = rows;
            this.deletedIds = deletedIds;
        }

        public static DataSet create(String id, String mapKey, Collection<DataSetDto.Row> rows, Collection<String> deletedIds) {
            return new DataSet(id, mapKey, rows, deletedIds);
        }

        public String getId() {
            return this.id;
        }

        public String getMapKey() {
            return this.mapKey;
        }

        public Collection<DataSetDto.Row> getRows() {
            return this.rows;
        }

        public Collection<String> getDeletedIds() {
            return this.deletedIds;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setMapKey(String mapKey) {
            this.mapKey = mapKey;
        }

        public void setRows(Collection<DataSetDto.Row> rows) {
            this.rows = rows;
        }

        public void setDeletedIds(Collection<String> deletedIds) {
            this.deletedIds = deletedIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataSet)) {
                return false;
            }
            DataSet other = (DataSet)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$mapKey = this.getMapKey();
            String other$mapKey = other.getMapKey();
            if (this$mapKey == null ? other$mapKey != null : !this$mapKey.equals(other$mapKey)) {
                return false;
            }
            Collection<DataSetDto.Row> this$rows = this.getRows();
            Collection<DataSetDto.Row> other$rows = other.getRows();
            if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
                return false;
            }
            Collection<String> this$deletedIds = this.getDeletedIds();
            Collection<String> other$deletedIds = other.getDeletedIds();
            return !(this$deletedIds == null ? other$deletedIds != null : !((Object)this$deletedIds).equals(other$deletedIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataSet;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $mapKey = this.getMapKey();
            result = result * 59 + ($mapKey == null ? 43 : $mapKey.hashCode());
            Collection<DataSetDto.Row> $rows = this.getRows();
            result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
            Collection<String> $deletedIds = this.getDeletedIds();
            result = result * 59 + ($deletedIds == null ? 43 : ((Object)$deletedIds).hashCode());
            return result;
        }

        public String toString() {
            return "SyncDataFileSnapshot.DataSet(id=" + this.getId() + ", mapKey=" + this.getMapKey() + ", rows=" + this.getRows() + ", deletedIds=" + this.getDeletedIds() + ")";
        }
    }
}

