/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.metas.entities;

import com.bcxin.runtime.domain.enums.BooleanStatus;
import com.bcxin.runtime.domain.metas.entities.ApplicationMetaEntity;
import com.bcxin.runtime.domain.metas.entities.DataSourceMetaEntity;
import com.bcxin.runtime.domain.metas.entities.FormSyncMetaEntity;
import com.bcxin.runtime.domain.metas.entities.enums.FormType;
import com.bcxin.saas.core.models.EntityBase;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="meta_forms")
public class FormMetaEntity
extends EntityBase<String> {
    @Id
    @Column(length=50)
    private String id;
    @Column(nullable=false)
    private String name;
    @Column(length=100, name="table_name")
    private String tableName;
    @Column(name="form_id", length=50, nullable=false)
    private String formId;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="application_meta_id")
    private ApplicationMetaEntity applicationMeta;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_updated_time")
    private Date lastUpdatedTime;
    @Column(nullable=false, columnDefinition="smallint default 0", name="form_type")
    @Enumerated(value=EnumType.ORDINAL)
    private FormType formType;
    @Column(nullable=false, columnDefinition="bit default 0", name="is_online")
    private BooleanStatus isOnline;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", nullable=false, columnDefinition="DATETIME default current_timestamp()")
    private Date createdTime;
    @OneToMany(mappedBy="formMeta", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Collection<FormSyncMetaEntity> formSyncMetas;

    public void change(String name, String tableName, FormType formType) {
        this.setName(name);
        this.setTableName(tableName);
        this.setLastUpdatedTime(this.lastUpdatedTime);
        this.setFormType(formType);
    }

    public DataSourceMetaEntity getDefaultDataSource() {
        if (this.getApplicationMeta() == null || this.getApplicationMeta().getDataSourceMetas() == null) {
            return null;
        }
        Optional<DataSourceMetaEntity> dataSourceMetaEntityOptional = this.getApplicationMeta().getDataSourceMetas().stream().filter(ii -> ii.getIsSelected() == BooleanStatus.TRUE).findFirst();
        if (dataSourceMetaEntityOptional.isPresent()) {
            return dataSourceMetaEntityOptional.get();
        }
        return null;
    }

    protected FormMetaEntity() {
        this.lastUpdatedTime = this.createdTime = new Date();
        this.setIsOnline(BooleanStatus.FALSE);
    }

    protected FormMetaEntity(String id, String formId, String name, String tableName, FormType formType) {
        this();
        this.setId(id);
        this.setName(name);
        this.setTableName(tableName);
        this.setFormId(formId);
        this.setLastUpdatedTime(this.lastUpdatedTime);
        this.setFormType(formType);
        this.setIsOnline(BooleanStatus.FALSE);
    }

    public static FormMetaEntity create(String formId, String name, String tableName, FormType formType) {
        return new FormMetaEntity(UUID.randomUUID().toString(), formId, name, tableName, formType);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFormId() {
        return this.formId;
    }

    public ApplicationMetaEntity getApplicationMeta() {
        return this.applicationMeta;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public FormType getFormType() {
        return this.formType;
    }

    public BooleanStatus getIsOnline() {
        return this.isOnline;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Collection<FormSyncMetaEntity> getFormSyncMetas() {
        return this.formSyncMetas;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setTableName(String tableName) {
        this.tableName = tableName;
    }

    protected void setFormId(String formId) {
        this.formId = formId;
    }

    protected void setApplicationMeta(ApplicationMetaEntity applicationMeta) {
        this.applicationMeta = applicationMeta;
    }

    protected void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setFormType(FormType formType) {
        this.formType = formType;
    }

    protected void setIsOnline(BooleanStatus isOnline) {
        this.isOnline = isOnline;
    }

    protected void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    protected void setFormSyncMetas(Collection<FormSyncMetaEntity> formSyncMetas) {
        this.formSyncMetas = formSyncMetas;
    }
}

