/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.metas.entities;

import com.bcxin.runtime.domain.enums.BooleanStatus;
import com.bcxin.runtime.domain.metas.entities.ApplicationMetaEntity;
import com.bcxin.runtime.domain.metas.entities.enums.DbType;
import com.bcxin.runtime.domain.metas.entities.enums.UseType;
import com.bcxin.saas.core.models.EntityBase;
import java.util.Date;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="meta_datasources")
public class DataSourceMetaEntity
extends EntityBase<String> {
    @Id
    @Column(length=100)
    private String id;
    @Column(length=100, nullable=false, name="data_source_id")
    private String dataSourceId;
    @Column(nullable=false)
    private String name;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(nullable=false, name="use_type")
    private UseType useType;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(nullable=false, name="db_type")
    private DbType dbType;
    @Column(nullable=false, name="is_selected")
    private BooleanStatus isSelected;
    @Column(nullable=true, length=2000)
    private String config;
    private String note;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_updated_time")
    private Date lastUpdatedTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", nullable=false, columnDefinition="DATETIME default current_timestamp()")
    private Date createdTime;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="application_meta_id")
    private ApplicationMetaEntity applicationMeta;

    public void change(String name, UseType useType, DbType dbType, String config, String note) {
        this.setName(name);
        this.setDbType(dbType);
        this.setUseType(useType);
        this.setConfig(config);
        this.setNote(note);
        this.setLastUpdatedTime(this.lastUpdatedTime);
    }

    protected DataSourceMetaEntity() {
        this.lastUpdatedTime = this.createdTime = new Date();
    }

    private DataSourceMetaEntity(String dataSourceId, String name, UseType useType, DbType dbType, String config, String note) {
        this();
        this.setId(UUID.randomUUID().toString());
        this.setDataSourceId(dataSourceId);
        this.setIsSelected(BooleanStatus.FALSE);
        this.change(name, useType, dbType, config, note);
    }

    public static DataSourceMetaEntity create(String dataSourceId, String name, UseType useType, DbType dbType, String config, String note) {
        return new DataSourceMetaEntity(dataSourceId, name, useType, dbType, config, note);
    }

    public String getId() {
        return this.id;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public String getName() {
        return this.name;
    }

    public UseType getUseType() {
        return this.useType;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public BooleanStatus getIsSelected() {
        return this.isSelected;
    }

    public String getConfig() {
        return this.config;
    }

    public String getNote() {
        return this.note;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public ApplicationMetaEntity getApplicationMeta() {
        return this.applicationMeta;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setUseType(UseType useType) {
        this.useType = useType;
    }

    protected void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    protected void setConfig(String config) {
        this.config = config;
    }

    protected void setNote(String note) {
        this.note = note;
    }

    protected void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    protected void setApplicationMeta(ApplicationMetaEntity applicationMeta) {
        this.applicationMeta = applicationMeta;
    }

    public void setIsSelected(BooleanStatus isSelected) {
        this.isSelected = isSelected;
    }
}

