/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.metas.commands;

import com.bcxin.runtime.domain.metas.entities.enums.DbType;
import com.bcxin.runtime.domain.metas.entities.enums.FormType;
import com.bcxin.runtime.domain.metas.entities.enums.UseType;
import com.bcxin.saas.core.commands.CommandAbstract;
import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import java.util.Collection;
import java.util.Optional;

public class RefreshAppCommand
extends CommandAbstract {
    private final Collection<Application> applications;

    public RefreshAppCommand(Collection<Application> applications) {
        this.applications = applications;
    }

    protected void validate() {
    }

    public static RefreshAppCommand create(Collection<Application> applications) {
        return new RefreshAppCommand(applications);
    }

    public Application matched(String id) {
        if (this.getApplications() == null) {
            return null;
        }
        Optional<Application> application = this.getApplications().stream().filter(ii -> ii.getId().equals(id)).findFirst();
        return application.isPresent() ? application.get() : null;
    }

    public Collection<Application> getApplications() {
        return this.applications;
    }

    public static class Form {
        private final String id;
        private final String name;
        private final String tableName;
        private final FormType formType;

        public Form(String id, String name, String tableName, FormType formType) {
            this.id = id;
            this.name = name;
            this.tableName = tableName;
            this.formType = formType;
        }

        public static Form create(String id, String name, String tableName, FormType formType) {
            return new Form(id, name, tableName, formType);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getTableName() {
            return this.tableName;
        }

        public FormType getFormType() {
            return this.formType;
        }
    }

    public static class DataSource {
        private final String id;
        private final String name;
        private final String driverClass;
        private final String useType;
        private final String config;
        private final int dbType;
        private final boolean isSelected;

        public DataSource(String id, String name, String useType, int dbType, String driverClass, String config, boolean isSelected) {
            this.id = id;
            this.name = name;
            this.useType = useType;
            this.driverClass = driverClass;
            this.config = config;
            this.dbType = dbType;
            this.isSelected = isSelected;
        }

        public static DataSource create(String id, String name, String useType, int dbType, String driverClass, String config, boolean isSelected) {
            return new DataSource(id, name, useType, dbType, driverClass, config, isSelected);
        }

        public DbType getEnumDbType() {
            switch (this.dbType) {
                case 4: {
                    return DbType.Mysql;
                }
                case 1: {
                    return DbType.Oracle;
                }
                case 2: {
                    return DbType.SqlServer;
                }
                case 6: {
                    return DbType.PostgreSql;
                }
                case 5: {
                    return DbType.HSQL;
                }
                case 7: {
                    return DbType.DM;
                }
                case 3: {
                    return DbType.DB2;
                }
            }
            throw new SaasNoSupportException();
        }

        public UseType getEnumDriveType() {
            if ("JDBC".equals(this.useType)) {
                return UseType.JDBC;
            }
            return UseType.JNDI;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDriverClass() {
            return this.driverClass;
        }

        public String getUseType() {
            return this.useType;
        }

        public String getConfig() {
            return this.config;
        }

        public int getDbType() {
            return this.dbType;
        }

        public boolean isSelected() {
            return this.isSelected;
        }
    }

    public static class Application {
        private final String id;
        private final String name;
        private final boolean isOnline;
        private final String note;
        private Collection<DataSource> dataSources;
        private Collection<Form> forms;

        public Application(String id, String name, boolean isOnline, String note) {
            this.id = id;
            this.name = name;
            this.isOnline = isOnline;
            this.note = note;
        }

        public static Application create(String id, String name, boolean isOnline, String note) {
            return new Application(id, name, isOnline, note);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOnline() {
            return this.isOnline;
        }

        public String getNote() {
            return this.note;
        }

        public Collection<DataSource> getDataSources() {
            return this.dataSources;
        }

        public Collection<Form> getForms() {
            return this.forms;
        }

        public void setDataSources(Collection<DataSource> dataSources) {
            this.dataSources = dataSources;
        }

        public void setForms(Collection<Form> forms) {
            this.forms = forms;
        }
    }
}

