/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.imports.services.impls;

import com.bcxin.runtime.domain.imports.commands.CreateDataImportCommand;
import com.bcxin.runtime.domain.imports.commands.CreateDataImportCommandResult;
import com.bcxin.runtime.domain.imports.components.DataImportComponentProvider;
import com.bcxin.runtime.domain.imports.dtos.WebUserDto;
import com.bcxin.runtime.domain.imports.entities.DataQueueEntity;
import com.bcxin.runtime.domain.imports.entities.enums.ProcessedStatus;
import com.bcxin.runtime.domain.imports.repositories.DataQueueRepository;
import com.bcxin.runtime.domain.imports.services.DataQueueService;
import com.bcxin.saas.core.components.JsonProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;

public class DataQueueServiceImpl
implements DataQueueService {
    private final DataQueueRepository dataQueueRepository;
    private final JsonProvider jsonProvider;
    private final DataImportComponentProvider dataImportComponentProvider;

    public DataQueueServiceImpl(DataQueueRepository dataQueueRepository, JsonProvider jsonProvider, DataImportComponentProvider dataImportComponentProvider) {
        this.dataQueueRepository = dataQueueRepository;
        this.jsonProvider = jsonProvider;
        this.dataImportComponentProvider = dataImportComponentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataImportCommandResult create(CreateDataImportCommand command) {
        Collection syncDocResponses = command.getDocRequests().stream().map(ix -> ix.getEventId()).distinct().map(ix -> CreateDataImportCommandResult.SyncDocResponse.create(ix, true, "\u5bfc\u5165\u6210\u529f")).collect(Collectors.toList());
        Collection eventIds = command.getDocRequests().stream().map(ix -> ix.getEventId()).collect(Collectors.toList());
        Collection<DataQueueEntity> dataQueueEntities = this.dataQueueRepository.getByEventIds(eventIds);
        Collection toBeProcessedRequests = command.getDocRequests().stream().filter(ix -> !dataQueueEntities.stream().anyMatch(dq -> dq.getReferenceId().equals(ix.getEventId()))).collect(Collectors.toList());
        ArrayList newDataQueueEntities = new ArrayList();
        try {
            command.getDocRequests().stream().forEach(ix -> {
                CreateDataImportCommandResult.SyncDocResponse responseItem = syncDocResponses.stream().filter(sdr -> sdr.getEventId().equals(ix.getEventId())).findFirst().get();
                boolean isDuplicated = dataQueueEntities.stream().anyMatch(dq -> dq.getReferenceId().equals(ix.getEventId()));
                if (isDuplicated && !ix.isFocusToUpdate()) {
                    responseItem.change(true, "\u5df2\u88ab\u5904\u7406\u8fc7\u7684\u5386\u53f2\u6570\u636e");
                } else {
                    DataQueueEntity queueEntity = DataQueueEntity.create(ix.getEventId(), new Date(), this.jsonProvider.getJson(ix));
                    try {
                        this.importDoc((CreateDataImportCommand.SyncDocRequest)ix);
                        queueEntity.changeStatus(ProcessedStatus.Done, "\u5b8c\u6210\u5bfc\u5165");
                        newDataQueueEntities.add(queueEntity);
                    }
                    catch (Exception ex) {
                        responseItem.change(false, ex.toString());
                        ex.printStackTrace();
                    }
                }
            });
            CreateDataImportCommandResult createDataImportCommandResult = CreateDataImportCommandResult.create(syncDocResponses);
            return createDataImportCommandResult;
        }
        finally {
            this.dataQueueRepository.saveAll(newDataQueueEntities);
        }
    }

    private void importDoc(CreateDataImportCommand.SyncDocRequest docRequest) throws Exception {
        WebUserDto webUserDto = this.dataImportComponentProvider.getCurrentUser();
        String userId = webUserDto.getId();
        String appId = docRequest.getAppId();
        String body = docRequest.getBody();
        String domainId = webUserDto.getDomainId();
        this.dataImportComponentProvider.saveWithoutValid(domainId, userId, appId, body);
    }
}

