package com.bcxin.saas.logging.jdbcs;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class Log4j2JdbcConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(Log4j2JdbcConnectionFactory.class);

    private static interface Singleton {
        final Log4j2JdbcConnectionFactory INSTANCE = new Log4j2JdbcConnectionFactory();
    }

    public Log4j2JdbcConnectionFactory() {
        System.err.println("初始化Log4j2JdbcConnectionFactory的实例对象信息");
    }

    private static volatile DataSource dataSource;
    private static volatile Properties properties;

    public static void setDataSource(Environment env) throws Exception {
        if (properties == null) {
            String url = env.getProperty("spring.datasource.url");
            String username = env.getProperty("spring.datasource.username");
            String password = env.getProperty("spring.datasource.password");
            String driver = env.getProperty("spring.datasource.driver-class-name");

            if (StringUtils.hasLength(url)) {
                properties = new Properties();
                properties.put("driverClassName", driver);
                properties.put("url", url);
                properties.put("username", username);
                properties.put("password", password);
            }
        }
    }

    public static Connection getConnection() throws SQLException {
        if (Singleton.INSTANCE.dataSource == null) {
            if(properties==null) {
                throw new RuntimeException("请先调用setDataSource方法");
            }

            try {
                dataSource = DruidDataSourceFactory.createDataSource(
                        properties
                );

            } catch (Exception ex) {
                logger.error("创建DataSource对象发生异常", ex);
            }
        }

        return Singleton.INSTANCE.dataSource.getConnection();
    }
}