package com.bcxin.event.repositories.repositories;

import com.bcxin.event.entities.EventSourceEntity;
import com.bcxin.event.enums.EventAction;
import com.bcxin.event.repositories.EventSourceRepository;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.Collection;
import java.util.Date;

public interface JpaEventSourceRepository extends EventSourceRepository,
        JpaRepository<EventSourceEntity,String> {

    @Query("select e from EventSourceEntity e where e.eventAction=?1 and e.metaId=?2 and e.createdTime>=?3 and e.createdTime<?4")
    Collection<EventSourceEntity> findAll(EventAction action, String metaId,  Date fromDate, Date toDate);
}
