package com.bcxin.saas.domain.repositories;

import com.bcxin.saas.domains.dtos.RbacQueryDTO;
import com.bcxin.saas.domains.repositories.RbacOptionRepository;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;

import java.util.*;

@Repository
public class RbacOptionRepositoryImpl implements RbacOptionRepository {

    private final NamedParameterJdbcTemplate jdbcTemplate;

    public RbacOptionRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public Set<String> findPermitOptions(RbacQueryDTO rbacQueryDTO) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("appCode",rbacQueryDTO.getAppId());
        paramMap.put("optionType", rbacQueryDTO.isMobile() ? 2 : 1);
        String sql;
        if(rbacQueryDTO.isDomainAdmin()){
            sql = "select option_code from rbac_permit_option where app_code = :appCode and option_type = :optionType";
        }else{
            paramMap.put("tenantEmployeeId",rbacQueryDTO.getEmployeeId());

            sql = " SELECT p.option_code " +
                    "FROM rbac_custom_role_user u" +
                    " JOIN rbac_permit_option_role p ON p.rbac_role_id = u.rbac_role_id " +
                    " WHERE u.tenant_employee_id = :tenantEmployeeId " +
                    " AND p.app_code = :appCode " +
                    " AND p.option_type = :optionType " +
                    " UNION " +
                    "SELECT p1.option_code  " +
                    " FROM rbac_permit_option_user p1 " +
                    " WHERE p1.tenant_employee_id = :tenantEmployeeId " +
                    " AND p1.app_code = :appCode " +
                    " AND p1.option_type = :optionType";
            }
        List<String> permitOptions = jdbcTemplate.queryForList(sql,paramMap, String.class);

        return new HashSet<>(permitOptions);
    }
}
