package com.bcxin.saas.domain.repositories;

import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import com.bcxin.saas.domains.entities.HmacAuthEntity;
import com.bcxin.saas.domains.repositories.HmacAuthRepository;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class HmacAuthRepositoryImpl implements HmacAuthRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public HmacAuthRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public <S extends HmacAuthEntity> List<S> saveAll(Iterable<S> entities) {
        throw new SaasNoSupportException();
    }

    public HmacAuthEntity findByClientId(String clientId) {
        String sql =
                "select t1.client_id,t1.`secret`,t1.expiredTime,t1.note,t1.created_time,t1.data_to_sign,t1.resource from sys_hmac_auths t1 where t1.client_id=:clientId";
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("clientId", clientId);

        try {
            HmacAuthEntity data = jdbcTemplate.queryForObject(sql, paramMap, new BeanPropertyRowMapper<>(HmacAuthEntity.class));

            if (data == null) {
                return null;
            }

            return data;
        } catch (EmptyResultDataAccessException ex) {
            return null;
        }
    }
}
