package com.bcxin.saas.domain.repositories;

import cn.hutool.core.util.StrUtil;
import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import com.bcxin.saas.domains.dtos.PageSearchDto;
import com.bcxin.saas.domains.entities.EmployeeEntity;
import com.bcxin.saas.domains.repositories.EmployeeRepository;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class EmployeeRepositoryImpl implements EmployeeRepository {

    private final NamedParameterJdbcTemplate jdbcTemplate;
    public EmployeeRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }



    @Override
    public List<EmployeeEntity> getEmployeeByDomainId(PageSearchDto searchDto) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("domainId",searchDto.getDomainId());

        String sql = "select t1.id,t2.`name`,t2.telephone as loginNo,t2.telephone as mobile,t2.email,t2.head_photo as avatar,t1.organization_id as domainId " +
                " from tenant_employees t1 " +
                " inner join tenant_users t2 on t1.tenant_user_id = t2.id " +
                " where t1.organization_id = :domainId " +
                " and t1.`status` != 1 ";

        if(StrUtil.isNotEmpty(searchDto.getContanctsId()) && !"all".equals(searchDto.getContanctsId())){
            sql += " and exists (select 1 from t_user_group_set t4 where t4.userId = t1.id and t4.userGroupId = :contanctsId)";
            paramMap.put("contanctsId", searchDto.getContanctsId());
        }

        if(StrUtil.isNotEmpty(searchDto.getUserName())){
            sql += " and t2.name like :userName";
            paramMap.put("userName","%"+searchDto.getUserName()+"%");
        }

        if(StrUtil.isNotEmpty(searchDto.getKeyWord())){
            sql += " and (t2.name like :keyWord or t2.telephone like :keyWord)";
            paramMap.put("keyWord","%"+searchDto.getKeyWord()+"%");
        }

        if(searchDto.isFromMail()){
            sql += " and t2.email is not null and t2.email !=''";
        }

        return jdbcTemplate.query(sql,paramMap,new BeanPropertyRowMapper<>(EmployeeEntity.class));
    }

    @Override
    public List<EmployeeEntity> getEmployeeByDepartId(String departId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("departId", departId);

        String sql =
                "SELECT t2.id, t3.`name`, t3.telephone AS loginNo, t3.telephone AS mobile, t3.email,t3.head_photo AS avatar,t2.organization_id AS domainId " +
                        "FROM tenant_employees t2 JOIN tenant_users t3 ON t2.tenant_user_id = t3.id join tenant_department_employee_relations t1 on t1.employee_id=t2.id\n" +
                        "where t1.department_id=:departId and t2.`status` in (0) ";

        return jdbcTemplate.query(sql, paramMap, new BeanPropertyRowMapper<>(EmployeeEntity.class));
    }

    @Override
    public List<EmployeeEntity> getEmployeeByRoleId(String roleId) {

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("roleId",roleId);

        String sql = "select t2.id,t3.`name`,t3.telephone as loginNo,t3.telephone as mobile,t3.email,t3.head_photo as avatar,t2.organization_id as domainId " +
                " from t_user_department_role_set t1 " +
                " inner join tenant_employees t2 on t1.userid = t2.id " +
                " inner join tenant_users t3 on t2.tenant_user_id = t3.id " +
                " where t1.roleid = :roleId " +
                " and t2.`status` != 1 ";
        return jdbcTemplate.query(sql,paramMap,new BeanPropertyRowMapper<>(EmployeeEntity.class));
    }

    @Override
    public <S extends EmployeeEntity> List<S> saveAll(Iterable<S> entities) {
        throw new SaasNoSupportException();
    }


    @Override
    public List<EmployeeEntity> queryEmployees(PageSearchDto searchDto) {
        Map<String, Object> paramMap = new HashMap<>();

        String sql = "select t2.id,t3.`name`,t3.telephone as loginNo,t3.telephone as mobile,t3.email,t3.head_photo as avatar,t2.organization_id as domainId " +
                " from t_user_department_role_set t1 " +
                " inner join tenant_employees t2 on t1.userid = t2.id " +
                " inner join tenant_users t3 on t2.tenant_user_id = t3.id " +
                " where t2.`status` != 1 ";
        if (StringUtils.hasLength(searchDto.getRoleId())){
            sql += " and t1.roleid = :roleId ";
            paramMap.put("roleId",searchDto.getRoleId());
        }
        if (StringUtils.hasLength(searchDto.getDomainId())){
            sql += " and t2.organization_id = :domainId " ;
            paramMap.put("domainId",searchDto.getDomainId());
        }

        return jdbcTemplate.query(sql,paramMap,new BeanPropertyRowMapper<>(EmployeeEntity.class));
    }
}
