package com.bcxin.saas.core.utils;

import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @version V1.0
 * @desc AES 加密工具类
 */
public class AESUtil {

	//编码方式
	public final static String ENCODING = "UTF-8";
	// 密钥
	public static final String AES_KEY = "2E9316AAB412DFAED10EFF5E03A1EF72";

	//智慧消防密钥
	//private static final String KEY = "EPQ1fpsGKapRBX9L";

	//智慧消防偏移量，AES 128位数据块对应偏移量为16位
	//public static final String VIPARA = "B2FC34EA89272357";   //AES 128位数据块对应偏移量为16位

	//AES：加密方式   CBC：工作模式   PKCS5Padding：填充模式
	private static final String CBC_PKCS5_PADDING = "AES/CBC/PKCS5Padding";

	private static final String AES = "AES";





	/**
	 * AES 加密操作
	 *
	 * @param content 待加密内容
	 * @param key     加密密钥
	 * @param VIPARA  偏移量
	 * @return 返回Base64转码后的加密数据
	 **/
	public static String encrypt(String content, String key,String VIPARA) {

		if (content == null || "".equals(content)) {
			return content;
		}

		try {
			/*
			 * 新建一个密码编译器的实例，由三部分构成，用"/"分隔，分别代表如下
			 * 1. 加密的类型(如AES，DES，RC2等)
			 * 2. 模式(AES中包含ECB，CBC，CFB，CTR，CTS等)
			 * 3. 补码方式(包含nopadding/PKCS5Padding等等)
			 * 依据这三个参数可以创建很多种加密方式
			 */
			Cipher cipher = Cipher.getInstance(CBC_PKCS5_PADDING);

			//偏移量
			IvParameterSpec zeroIv = new IvParameterSpec(VIPARA.getBytes(ENCODING));

			byte[] byteContent = content.getBytes(ENCODING);

			//使用加密秘钥
			SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes(ENCODING), AES);
			//SecretKeySpec skeySpec = getSecretKey(key);

			cipher.init(Cipher.ENCRYPT_MODE, skeySpec, zeroIv);// 初始化为加密模式的密码器

			byte[] result = cipher.doFinal(byteContent);// 加密

			return Base64.encodeBase64String(result);//通过Base64转码返回
		} catch (Exception ex) {
			Logger.getLogger(AESUtil.class.getName()).log(Level.SEVERE, null, ex);
		}

		return null;

	}

	/**
	 * AES 加密
	 *
	 * @param text
	 *            待加密的字符串
	 * @return 加密后的byte[] 数组
	 * @throws Exception
	 */
	public static String encode(String text) throws Exception {
		try {
			String base64Key = AES_KEY;
			byte[] key = parseHexStr2Byte(base64Key);
			SecretKeySpec sKeySpec = new SecretKeySpec(key, "AES");
			Cipher cipher = Cipher.getInstance("AES");
			cipher.init(Cipher.ENCRYPT_MODE, sKeySpec);
			byte[] bjiamihou = cipher.doFinal(text.getBytes(ENCODING));
			String result = parseByte2HexStr(bjiamihou);
			return result;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * AES解密
	 *
	 * @param text
	 *            待解密的字符串
	 * @return 解密后的字符串
	 * @throws Exception
	 */
	public static String decode(String text) throws Exception {
		String base64Key = AES_KEY;
		byte[] key = parseHexStr2Byte(base64Key);
		SecretKeySpec sKeySpec = new SecretKeySpec(key, "AES");
		Cipher cipher = Cipher.getInstance("AES");
		cipher.init(Cipher.DECRYPT_MODE, sKeySpec);
		byte[] bjiemihou = cipher.doFinal(parseHexStr2Byte(text));
		String result = new String(bjiemihou, "UTF-8");
		return result;
	}

	/**
	 * 生成密钥 自动生成base64 编码后的AES128位密钥
	 *
	 * @throws NoSuchAlgorithmException
	 * @throws Exception
	 */
	public static String getAESKey() throws Exception {
		KeyGenerator kg = KeyGenerator.getInstance("AES");
		kg.init(128);// 要生成多少位，只需要修改这里即可128, 192或256
		SecretKey sk = kg.generateKey();
		byte[] b = sk.getEncoded();
		return parseByte2HexStr(b);
	}

	/**
	 * 将16进制转换为二进制
	 *
	 * @param hexStr
	 * @return
	 */
	public static byte[] parseHexStr2Byte(String hexStr) {
		if (hexStr.length() < 1)
			return null;
		byte[] result = new byte[hexStr.length() / 2];
		for (int i = 0; i < hexStr.length() / 2; i++) {
			int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
			int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
			result[i] = (byte) (high * 16 + low);
		}
		return result;
	}

	/**
	 * 将二进制转换成16进制
	 *
	 * @param buf
	 * @return
	 */
	public static String parseByte2HexStr(byte buf[]) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < buf.length; i++) {
			String hex = Integer.toHexString(buf[i] & 0xFF);
			if (hex.length() == 1) {
				hex = '0' + hex;
			}
			sb.append(hex.toUpperCase());
		}
		return sb.toString();
	}

	public static byte[] AES_CBC_Decrypt(byte[] data, byte[] key, byte[] iv) throws Exception {
		Cipher cipher = getCipher(Cipher.DECRYPT_MODE, key, iv);
		return cipher.doFinal(data);
	}

	private static Cipher getCipher(int mode, byte[] key, byte[] iv) throws Exception {
		Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");

		// 因为AES的加密块大小是128bit(16byte), 所以key是128、192、256bit无关
		// cipher.getBlockSize());

		SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
		cipher.init(mode, secretKeySpec, new IvParameterSpec(iv));

		return cipher;
	}


}