package com.bcxin.saas.core.components;

import com.alibaba.fastjson.JSON;
import com.bcxin.saas.core.exceptions.SaasBadException;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.Collections;

public interface JsonProvider {
    <T> T getData(String json, Class<T> tClass);

    <T> String getJson(T data);

    <T>Collection<T> getDataList(String json,Class<T> tClass);

    public static class JsonProviderImpl implements JsonProvider {
        @Override
        public <T> T getData(String json, Class<T> tClass) {
            if(StringUtils.isBlank(json)) {
                return null;
            }

            try {
                return JSON.parseObject(json, tClass);
            } catch (Exception ex) {
                throw new SaasBadException("JSON反序列化异常", ex);
            }
        }

        @Override
        public <T> String getJson(T data) {
            try {
                return JSON.toJSONString(data);
            } catch (Exception ex) {
                throw new SaasBadException("JSON序列化异常", ex);
            }

        }

        @Override
        public <T> Collection<T> getDataList(String json, Class<T> tClass) {
            if (StringUtils.isEmpty(json)) {
                return Collections.EMPTY_LIST;
            }

            return JSON.parseArray(json, tClass);
        }
    }
}
