package com.bcxin.saas.core.components;

import com.bcxin.saas.core.components.dtos.DataPermissionType;
import com.bcxin.saas.core.enums.EnvironmentType;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.HashSet;

@Getter
public class DataPermissionScopeConfig {
    public static final String ALL_PERMISSIONS = "*";
    private final String dataScoped;

    private final Collection<String> conditionAppIds;

    private final EnvironmentType environmentType;

    public DataPermissionScopeConfig(String dataScoped,
                                     Collection<String> conditionAppIds,
                                     EnvironmentType environmentType) {
        this.dataScoped = dataScoped;
        this.environmentType = environmentType;
        if(conditionAppIds!=null) {
            this.conditionAppIds = conditionAppIds;
        }else {
            this.conditionAppIds = new HashSet<>();
        }
    }

    public boolean isAllowedAllData() {
        return (environmentType == EnvironmentType.Government_Inner || environmentType == EnvironmentType.Government_Network) && !StringUtils.isEmpty(dataScoped) && "all".equalsIgnoreCase(dataScoped);
    }

    public boolean isConditionLimitedApp(String appId) {
        return this.getConditionAppIds().stream().anyMatch(ii -> ii.equalsIgnoreCase(appId));
    }

    public static String getPermissionCacheKey(DataPermissionType permissionType, String id) {
        return String.format("com:scopes:pms:%s:%s", permissionType, id);
    }

    public static String getPermissionScopeCacheKey(DataPermissionType permissionType, String id) {
        return String.format("com:scopes:pms:%s:scope:%s", permissionType, id);
    }
}
