package com.bcxin.saas.core.components;

import com.bcxin.saas.core.exceptions.SaasForbidException;
import com.bcxin.saas.core.models.AppAclModel;

import java.util.Date;

public interface ClientAccessProvider {
    String createToken(String userId, Date expiredTime);

    String getUserId(String token);

    static class ClientAccessProviderImpl implements ClientAccessProvider
    {
        private final JsonProvider jsonProvider;
        private final EncryptProvider encryptProvider;

        public ClientAccessProviderImpl(JsonProvider jsonProvider,
                                        EncryptProvider encryptProvider) {
            this.jsonProvider = jsonProvider;
            this.encryptProvider = encryptProvider;
        }

        @Override
        public String createToken(String userId, Date expiredTime) {
            AppAclModel appAclModel = AppAclModel.create(userId, expiredTime);
            String json = jsonProvider.getJson(appAclModel);

            return encryptProvider.encode(json);
        }

        @Override
        public String getUserId(String token) {
            try {
                String plainText = this.encryptProvider.decode(token);

                AppAclModel aclModel = jsonProvider.getData(plainText, AppAclModel.class);
                if (aclModel != null) {
                    return aclModel.getUserId();
                }

                return null;
            } catch (Exception ex) {
                throw new SaasForbidException(String.format("未授权token(%s)无效", token), ex);
            }
        }
    }
}
