package com.bcxin.saas.core;

public class Constants {
    private static String USER_PROFILE_COOKIE_NAME_FORMAT="v5_gu_p_";
    private static final String OA_APPLICATION_ID = "__xkeybkGaZa1SboC9GL1"; //智能人事应用
    private static final String USER_MANAGEMENT_APPLICATION_ID = "__d1qEDy3wYq8VF5KvUoE"; //机构用户管理应用

    //集团组织智能人事应排除的菜单
    private static final String[] PREMIUM_OA_APP_MENUS_EXCLUDE = new String[]{
            "__qdywuldO1n6qTHe0Csc" //角色授权
        };

    //普通组织智能人事应排除的菜单
    private static final String[] BASIC_OA_APP_MENUS_EXCLUDE = new String[]{
            "__DxkfGILdtLrj99f5QP0", //集团组织管理
            "__92aTCdLa5qBstiuCNdn", //功能授权
            "__PZedFFzgwyuOsUjjgsP", //组织类型管理
            "__iTaFW6tDa6TL6pLghmm", //角色管理
            "__03W8axei1LgpcCYkI1s" //集团架构图
    };

    public static String getOaApplicationId() {
        return OA_APPLICATION_ID;
    }
    public static String getUserManagementApplicationId(){
        return USER_MANAGEMENT_APPLICATION_ID;
    }

    public static String[] getPremiumOaAppMenusExclude() {
        return PREMIUM_OA_APP_MENUS_EXCLUDE;
    }

    public static String[] getBasicOaAppMenusExclude() {
        return BASIC_OA_APP_MENUS_EXCLUDE;
    }

    public static String getUserProfileCookieName(String userId) {
        return USER_PROFILE_COOKIE_NAME_FORMAT.concat(userId);
    }

    public static String getUserProfileCookiePrefixName() {
        return USER_PROFILE_COOKIE_NAME_FORMAT;
    }

    public static String getUserNodeRedisKey(String userId) {
        return String.format("v5:USER_NODE_REDIS_KEY:%s", userId);
    }

    public static String getUserMapRedisKey(String userId) {
        return String.format("v5:USER_MAP_REDIS_KEY:%s", userId);
    }
}
