package com.bcxin.saas.domain.repositories;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import com.bcxin.saas.domains.dtos.RbacQueryDTO;
import com.bcxin.saas.domains.entities.RbacAppEntity;
import com.bcxin.saas.domains.repositories.RbacAppRepository;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.*;

@Repository
public class RbacAppRepositoryImpl implements RbacAppRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public RbacAppRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public <S extends RbacAppEntity> List<S> saveAll(Iterable<S> entities) {
        throw new SaasNoSupportException();
    }

    @Override
    public List<RbacAppEntity> findPermitApps(RbacQueryDTO rbacQueryDTO) {
        Map<String, Object> paramMap = new HashMap<>();
        String sql;
        if(rbacQueryDTO.isDomainAdmin()){
            List<String> boundApps = getBoundAppList(rbacQueryDTO.getOrganizationId());
            paramMap.put("boundApps",boundApps);
            paramMap.put("appTypes", rbacQueryDTO.isMobile() ? Arrays.asList(2,3) : Arrays.asList(1,3));

            sql = "select app_code AS appCode, app_logo AS appLogo, app_name AS appName, category AS category, category_seq as categorySeq, seq as appSeq " +
                    " from rbac_permit_app where app_code in (:boundApps) and app_type in (:appTypes)" +
                    " order by categorySeq, appSeq asc";
        }else{
            paramMap.put("tenantEmployeeId",rbacQueryDTO.getEmployeeId());
            List<Integer> permit_type = rbacQueryDTO.isMobile() ? Arrays.asList(2,3) : Arrays.asList(1,3);
            paramMap.put("permit_type",permit_type);
            sql = "SELECT a.app_code AS appCode, a.app_logo AS appLogo, a.app_name AS appName, a.category AS category, a.category_seq as categorySeq, a.seq as appSeq " +
                    " FROM rbac_permit_app a WHERE a.id IN (" +
                    "  SELECT p.permit_app_id FROM rbac_custom_role_user u" +
                    "   JOIN rbac_permit_app_role p ON p.rbac_role_id = u.rbac_role_id" +
                    "   WHERE u.tenant_employee_id = :tenantEmployeeId" +
                    "   AND p.permit_type IN (:permit_type)" +
                    " UNION" +
                    "   SELECT p1.permit_app_id FROM rbac_permit_app_user p1" +
                    "   WHERE p1.tenant_employee_id = :tenantEmployeeId" +
                    "   AND p1.permit_type IN (:permit_type))" +
                    " order by categorySeq, appSeq asc";
        }

        List<RbacAppEntity> permitApps = jdbcTemplate.query(sql,paramMap,new BeanPropertyRowMapper<>(RbacAppEntity.class));

        return permitApps;
    }

    @Override
    public RbacAppEntity findByAppCode(String appCode) {
        String sql = "select app_code AS appCode, app_logo AS appLogo, app_name AS appName, category AS category, category_seq as categorySeq, seq as appSeq " +
                " from rbac_permit_app where app_code = :appCode";
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("appCode",appCode);
        List<RbacAppEntity> appEntityList = jdbcTemplate.query(sql,paramMap,new BeanPropertyRowMapper<>(RbacAppEntity.class));
        return appEntityList.stream().findFirst().orElse(null);
    }

    private List<String> getBoundAppList(String organizationId){
        Map<String, Object> tDomainParamMap = new HashMap<>();
        tDomainParamMap.put("organizationId", organizationId);
        String sql = "select BIND_APPLICATIONS from t_domain where ID = :organizationId";
        List<String> bindAppJsonList = jdbcTemplate.queryForList(sql,tDomainParamMap,String.class);
        if(bindAppJsonList != null && !bindAppJsonList.isEmpty()){
           return  JSONObject.parseArray(bindAppJsonList.get(0),String.class);
        }else{
            return Collections.emptyList();
        }
    }
}
