package com.bcxin.saas.core.utils;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

public class DocumentIdExtractUtil {

    public static IdValue extract(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        if (!id.contains("--")) {
            return new IdValue(id, null);
        }

        int splittedLastIndex = id.lastIndexOf("--");
        String formattedId = id.substring(0, splittedLastIndex);
        String formattedFormId = id.substring(splittedLastIndex + 2);

        return new IdValue(formattedId, formattedFormId);
    }

    @Getter
    public static class IdValue {
        private final String id;
        private final String formId;

        public IdValue(String id, String formId) {
            this.id = id;
            this.formId = formId;
        }

        public boolean isBusinessId() {
            return !StringUtils.isBlank(this.getFormId());
        }
    }
}
