package com.bcxin.saas.core.logs;
import com.bcxin.saas.core.InjectResolverFactory;
import com.bcxin.saas.core.components.FeatureOptionChecker;
import com.bcxin.saas.core.components.SessionProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;


public class OutputLogProvider {
    private static final Logger logger = LoggerFactory.getLogger(OutputLogProvider.class);
    private final String sessionId;
    private final String userId;
    private final Map params;
    private static WeakReference<ThreadLocal<Collection<LoggerEventMessage>>> localMessageContainer =
            new WeakReference<>(new ThreadLocal<>());

    public OutputLogProvider(String sessionId, String userId, Map params) {
        this.sessionId = sessionId;
        this.userId = userId;
        this.params = params;
    }

    public void printlnText(String appId, String content) {
        if (!FeatureOptionChecker.isEnable("ENABLE_PRINTED")) {
            return;
        }

        try {
            Collection<LoggerEventMessage> loggerEventMessages = getLocalMessages().get();
            if (loggerEventMessages == null) {
                loggerEventMessages = new ArrayList<>();
            }
            if (loggerEventMessages.size() > 100) {
                loggerEventMessages.remove(loggerEventMessages.stream().findFirst().get());
            }

            loggerEventMessages.add(LoggerEventMessage.create(this.sessionId, String.format("userId=%s;appId=%s", this.userId, appId), content, this.params, Level.ERROR));
            storeLocalMessages(loggerEventMessages);
        } catch (Exception ex) {
            logger.error("OutputLogProvider.print: appId={};content={}", appId, content, ex);
        }
    }

    public void println(String appId, Object content) {
        printlnText(appId, String.format("objectContent=%s", content));
    }

    public static void flush() {
        try {
            Collection<LoggerEventMessage> loggerEventMessages = getLocalMessages().get();
            SessionProvider sessionProvider = InjectResolverFactory.resolve(SessionProvider.class);
            // LoggerProvider loggerProvider = InjectResolverFactory.resolve(LoggerProvider.class);

            if (loggerEventMessages == null) {
                //loggerProvider.appends(loggerEventMessages);
                loggerEventMessages = new ArrayList<>();
            }

            Collection<LoggerEventMessage> sessionLoggerEvents = new ArrayList<>();
            sessionLoggerEvents.addAll(loggerEventMessages);

            Object sessionValue = sessionProvider.getAttribute(SysLogProvider.DEBUG_SESSION);
            if (sessionValue != null) {
                sessionLoggerEvents.addAll((Collection<LoggerEventMessage>) sessionValue);
            }

            sessionProvider.setAttribute(SysLogProvider.DEBUG_SESSION, sessionLoggerEvents);

            loggerEventMessages.clear();
            storeLocalMessages(null);
        } catch (Exception ex) {
            logger.error("OutputLogProvider.flush", ex);
        }
    }

    public static boolean readyFlush(int expectedCount) {
        try {
            Collection<LoggerEventMessage> sysLogMessages = getLocalMessages().get();
            if (sysLogMessages != null) {
                return sysLogMessages.size() >= expectedCount;
            }

            return false;
        } catch (Exception ex) {
            logger.error("OutputLogProvider.readyFlush", ex);
        }

        return false;
    }

    private static ThreadLocal<Collection<LoggerEventMessage>> getLocalMessages() {
        if (localMessageContainer == null || localMessageContainer.get() == null) {
            localMessageContainer = new WeakReference<>(new ThreadLocal<>());
        }

        return localMessageContainer.get();
    }

    private static void storeLocalMessages(Collection<LoggerEventMessage> value) {
        ThreadLocal<Collection<LoggerEventMessage>> threadLocal = getLocalMessages();
        threadLocal.set(value);
    }

    public static void directPrint(String msg) {
        logger.error("system error:{}", msg);
    }
}
