package com.bcxin.saas.core.components;

import cn.hutool.http.HttpUtil;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.bcxin.saas.core.utils.JsonUtil;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.apache.commons.codec.binary.Base64;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class IdentityChecker {
    public String getCheckResult(String url, String idNumber) {
        Map<String, Object> paramMap = new HashMap<>();

        try {
            paramMap.put("idNumber", this.createJwt(idNumber));

            String resultStr = HttpUtil.post(url, paramMap);

            return resultStr;
        } catch (Exception ex) {
            String msg = String.format("url=[%s]; param=[%s]; detail=[%s];",
                    url, JsonUtil.getJson(paramMap), ExceptionUtils.getStackMessage(ex));

            throw new SaasBadException(msg, ex);
        }
    }

    /**
     * 私钥（测试秘钥）
     * 生产秘钥正式上线提供
     */
    private static final String JWT_SECRET = "xxx_test_secret";

    /**
     * 1小时
     */
    private static final int JWT_REFRESH_TTL = 60 * 60 * 1000;


    /**
     * 创建jwt
     */
    private static String createJwt(String subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
                .setSubject(subject)
                .signWith(signatureAlgorithm, generalKey());
        // 设置过期时间
        long expMillis = System.currentTimeMillis() + JWT_REFRESH_TTL;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    /**
     * 解密jwt
     */
    private static String parseJwt(String token) {
        return Jwts.parser()
                .setSigningKey(generalKey())
                .parseClaimsJws(token)
                .getBody()
                .getSubject();
    }

    /**
     * 由字符串生成加密key
     */
    private static SecretKey generalKey() {
        byte[] encodedKey = Base64.decodeBase64(JWT_SECRET);
        return new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
    }
}
