package com.bcxin.saas.core;

import com.bcxin.saas.core.exceptions.SaasBadException;

public class InjectResolverFactory {
    private static InjectResolver injectResolver;
    public static void setInjectResolver(InjectResolver injectResolver) {
        InjectResolverFactory.injectResolver = injectResolver;
    }

    public static <T> T resolve(Class<T> tClass) {
        if (injectResolver == null) {
            throw new SaasBadException("InjectResolverFactory未正确初始化");
        }

        return injectResolver.resolve(tClass);
    }

    public static <T> T resolve(String beanName) {
        if (injectResolver == null) {
            throw new SaasBadException("InjectResolverFactory未正确初始化");
        }

        return injectResolver.resolve(beanName);
    }
}
