/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.domains.dtos;

import com.bcxin.saas.domains.dtos.PageSearchDto;
import java.util.Collections;
import java.util.List;

public class PageResultDto {
    private int pageCount;
    private int linesPerPage;
    private int rowCount;
    private int pageNum;
    private List datas;

    public PageResultDto(int linesPerPage, int rowCount, int pageNum, List datas) {
        this.linesPerPage = linesPerPage;
        this.rowCount = rowCount;
        this.pageNum = pageNum;
        this.pageCount = (datas.size() + linesPerPage - 1) / linesPerPage;
        int fromIndex = (pageNum - 1) * linesPerPage;
        if (fromIndex >= datas.size()) {
            this.datas = Collections.emptyList();
        } else {
            int toIndex = pageNum * linesPerPage;
            if (toIndex >= datas.size()) {
                toIndex = datas.size();
            }
            this.datas = datas.subList(fromIndex, toIndex);
        }
    }

    public static PageResultDto create(PageSearchDto searchDto, List datas) {
        return new PageResultDto(searchDto.getPageSize(), datas.size(), searchDto.getPageNum(), datas);
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getLinesPerPage() {
        return this.linesPerPage;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public List getDatas() {
        return this.datas;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public void setLinesPerPage(int linesPerPage) {
        this.linesPerPage = linesPerPage;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public void setDatas(List datas) {
        this.datas = datas;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResultDto)) {
            return false;
        }
        PageResultDto other = (PageResultDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageCount() != other.getPageCount()) {
            return false;
        }
        if (this.getLinesPerPage() != other.getLinesPerPage()) {
            return false;
        }
        if (this.getRowCount() != other.getRowCount()) {
            return false;
        }
        if (this.getPageNum() != other.getPageNum()) {
            return false;
        }
        List this$datas = this.getDatas();
        List other$datas = other.getDatas();
        return !(this$datas == null ? other$datas != null : !((Object)this$datas).equals(other$datas));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResultDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageCount();
        result = result * 59 + this.getLinesPerPage();
        result = result * 59 + this.getRowCount();
        result = result * 59 + this.getPageNum();
        List $datas = this.getDatas();
        result = result * 59 + ($datas == null ? 43 : ((Object)$datas).hashCode());
        return result;
    }

    public String toString() {
        return "PageResultDto(pageCount=" + this.getPageCount() + ", linesPerPage=" + this.getLinesPerPage() + ", rowCount=" + this.getRowCount() + ", pageNum=" + this.getPageNum() + ", datas=" + this.getDatas() + ")";
    }
}

