/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.domains.dtos;

import com.bcxin.saas.core.models.CacheItemAbstract;
import java.util.Calendar;
import java.util.List;

public class DomainRelationDTO
extends CacheItemAbstract {
    private String domainId;
    private List<String> childDomainIds;

    public static DomainRelationDTO create(String domainId, List<String> childDomainIds) {
        DomainRelationDTO domainRelationDTO = new DomainRelationDTO();
        domainRelationDTO.setDomainId(domainId);
        domainRelationDTO.setChildDomainIds(childDomainIds);
        Calendar nowTime = Calendar.getInstance();
        nowTime.add(12, 5);
        domainRelationDTO.setExpiredTime(nowTime.getTime());
        return domainRelationDTO;
    }

    public boolean getIsSuperDomain() {
        return this.childDomainIds != null && this.childDomainIds.stream().anyMatch(ii -> "*".equals(ii));
    }

    private DomainRelationDTO() {
    }

    public static DomainRelationDTO create(String domainId, List<String> childDomainIds, boolean isEnabled) {
        DomainRelationDTO relationDTO = new DomainRelationDTO();
        relationDTO.setDomainId(domainId);
        relationDTO.setChildDomainIds(childDomainIds);
        return relationDTO;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public List<String> getChildDomainIds() {
        return this.childDomainIds;
    }

    private void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    private void setChildDomainIds(List<String> childDomainIds) {
        this.childDomainIds = childDomainIds;
    }
}

