/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.core.utils.encrypt;

import com.bcxin.saas.core.utils.SecurityUtil;
import com.bcxin.saas.core.utils.encrypt.Digests;
import com.bcxin.saas.core.utils.encrypt.Encodes;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtils {
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;
    public static byte[] encPub = Base64.decode((String)"MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAESic24soUECzuSh2aYH0e+hQYh+/I01NmfjOnm5mwyUEYQvNCPTzn3BlNyufgMV+DWLUKV+2h0+PVel9jYTfG8Q==");
    public static byte[] encPriv = Base64.decode((String)"MIGTAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBHkwdwIBAQQg0dYU+I6IdiSe8bvWlsHuWfsjSn3XFZqOGWO3K1814O6gCgYIKoEcz1UBgi2hRANCAARKJzbiyhQQLO5KHZpgfR76FBiH78jTU2Z+M6ebmbDJQRhC80I9POfcGU3K5+AxX4NYtQpX7aHT49V6X2NhN8bx");
    public static Logger logger = LoggerFactory.getLogger(PasswordUtils.class);

    public static Map<String, String> entryptPassword(String plainPassword) {
        byte[] salt = Digests.generateSalt(8);
        byte[] hashPassword = Digests.sha1(plainPassword.getBytes(), salt, 1024);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hashPassword", Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword));
        map.put("salt", salt.toString());
        return map;
    }

    public static boolean validatePassword(String plainPassword, String password) {
        byte[] salt = Encodes.decodeHex(password.substring(0, 16));
        byte[] hashPassword = Digests.sha1(plainPassword.getBytes(), salt, 1024);
        return password.equals(Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword));
    }

    public static String initSign(String password) {
        try {
            KeyFactory keyFact = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
            Signature signature = Signature.getInstance("SM3withSm2", (Provider)new BouncyCastleProvider());
            PrivateKey priv = keyFact.generatePrivate(new PKCS8EncodedKeySpec(encPriv));
            signature.initSign(priv);
            signature.update(password.getBytes(StandardCharsets.UTF_8));
            byte[] signatureValue = signature.sign();
            return Hex.toHexString((byte[])signatureValue);
        }
        catch (Exception ex) {
            logger.error("\u56fd\u5bc6\u7b7e\u540d\u9519\u8bef\uff1a{}", (Object)ex.getMessage());
            return "";
        }
    }

    public static boolean initVerify(String password, String hexPass) {
        try {
            KeyFactory keyFact = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
            Signature signature = Signature.getInstance("SM3withSm2", (Provider)new BouncyCastleProvider());
            PublicKey pub = keyFact.generatePublic(new X509EncodedKeySpec(encPub));
            signature.initVerify(pub);
            signature.update(password.getBytes(StandardCharsets.UTF_8));
            boolean res = signature.verify(Hex.decode((String)hexPass));
            return res;
        }
        catch (Exception ex) {
            logger.error("\u56fd\u5bc6\u9a8c\u8bc1\u7b7e\u540d\u9519\u8bef\uff1a{}", (Object)ex.getMessage());
            return false;
        }
    }

    public static boolean isMatched(String expectedPassword, String actualPassword) {
        if (StringUtils.isEmpty((CharSequence)actualPassword) || StringUtils.isEmpty((CharSequence)expectedPassword)) {
            return false;
        }
        try {
            boolean bo = false;
            boolean bl = bo = expectedPassword != null && (actualPassword.equals(SecurityUtil.decryptPassword(expectedPassword)) || PasswordUtils.validatePassword(actualPassword, expectedPassword) || expectedPassword.equals(SecurityUtil.encryptOld(actualPassword))) || actualPassword.equals(expectedPassword);
            if (!bo) {
                bo = PasswordUtils.initVerify(actualPassword, expectedPassword);
            }
            return bo;
        }
        catch (Exception ex) {
            logger.error("\u5bc6\u7801\u6bd4\u5bf9\u5f02\u5e38", (Throwable)ex);
            return false;
        }
    }
}

