/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.core.utils;

import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.exceptions.SaasRetryableException;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    private static final Logger logger = LoggerFactory.getLogger(RetryUtil.class);

    public static <T> T execute(Callable<T> function, int retryCount) {
        try {
            Retryer retryer = RetryerBuilder.newBuilder().retryIfExceptionOfType(SaasRetryableException.class).withStopStrategy(StopStrategies.stopAfterAttempt((int)retryCount)).withWaitStrategy(WaitStrategies.fixedWait((long)5L, (TimeUnit)TimeUnit.MILLISECONDS)).build();
            return (T)retryer.call(() -> {
                try {
                    return function.call();
                }
                catch (Exception e) {
                    if (!ExceptionUtils.getStackMessage(e).contains("504")) {
                        throw new SaasRetryableException(e);
                    }
                    throw e;
                }
            });
        }
        catch (Exception e) {
            throw new SaasBadException(String.format("failed to execute max retries(%s)", retryCount), e);
        }
    }

    public static <T> T execute(Callable<T> function) {
        return RetryUtil.execute(function, 2);
    }
}

