/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.core.utils;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSAUtils {
    public static final String RSA_ECB_PKCS1_PADDING = "RSA/ECB/PKCS1Padding";
    public static final int KEY_SIZE_2048 = 2048;
    public static final int KEY_SIZE_1024 = 1024;
    private static final String ALGORITHM = "RSA";
    private static final String PRIVATE_KEY = "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQD5NbNR+UA6rPtwU4J7TogQI7cmrqRXms+tWGFRsodznGpSvau5br1RcLPcQ6MVeFZ/9RuvbKwN7HFXyUs/mQ/1u6TcG/P5xp6lFHkrkOUGHygXXUDCVwZNJV60yvObifIMdUKrakXs14X8n+wVmv62VT/GcjpuWr5lOUghW5tGSaxS20VBqZfcv0AJS6Rpqce/0AWtPA+3MJvXBJQskISCjfZQorakGHkjRfEvwmgE/8+4ENKxWn+zKyH1s92m08ZETkOCpNACT6vPbn7XFO2VbIgiGkwIekleUh0OpWrzH13c2wsalUfsVheIuI+KXTuH8qQ8AzemdRBRNDtIjpiZAgMBAAECggEAW7y95xYm47Kb2IyVQsj042QSXsX5L1qIypn3MTjUDeXtacnydg9i16DyRMoNNbEXvoC/EUOiznlUe+lYru+sZVwO4wvTMwY/jitMM5JiDG/ZtUgZt7CLXEi+ZTU0mfQcyyM7SJiVZwsrgoRoRsfIrdwR3v5brhXvcpm0iLsNHMD2HQf2zu6H41s5G5forjM58Za+d6sK80X1EtViIBQt/861A58/bfU5QbDyAd1W/9tKElUbl7UmEXXuybcBnkVEj3ebOw/XDueIYohu2sf3MBBxABe7FFXHIyBNVMSZeGNg4tdm90uoCotM26nDNABSo1jR+YSeTNVO+o7g1gGclQKBgQD98uS+HGwD03NAaTde8FSu953LQie5fe8rI7wqExNfxPu8yohC30kwJI6JghxiD7496ZXrowqaspgwxuVzF9V7vPyP3QyfEaBF2o0bxf2hrfKw5bwwAY/WEv0pCgJcsacUCtnsbHh91azFe6yLQ9YldZasQSFozbmpw+a7oUwQ6wKBgQD7OQH6tGfrbtjGaRypfu+r6Tjhha/6boPlT6s3tjSSQsow7NRaT1LwQLTh91HdnzywZzqxm7YzkATU5YazbJI3QCAg5QzG/6mEODYwbUjk/pokJD16RCJuXGlao+S/koV2/Z/xVIj4E4GWUIH0BXavUH6nZ3Dk3v81nRVZfEH7iwKBgDw1REpWjr1xepfA2mHl9Q3uozi3nJd75iKCPHB1SVihaVXfZuMD8WQ6ppivgm81cFNZeDP/2dnHkhGudmQNOI43xmGNdRqZoTguktoM3Q9iIHIUZcOz+xg0NFVwjBLSA9zancRSC1c6O9YudkAmezUyZeC9KGCitewsCB5gJZq1AoGBAMcCZfsAJsJuUPL8GWR71cjNO+4LRViRa5KgBfZgNE0Y86rGMYJJDF6eI6xNi2CQ4Datz+UagL9f+zPbj1VbUIjMF6d3SyPpK5Q+I09Bg1lEBz9SJhFRICVkt2DCLFdF7sxQJf+7A7XhXeqBZDC2k0pV7b8XRmtH68vA4ES/FlX5AoGAAOKsQ2h33u17mYCa2GjXLHdhdFq2ZUZRoegwzOr2OWI0N1nhWzSiBNeq7KzvpVTkeVy6pxLvWjLgApLxdo8voBxXEKQade5TQAcHEvggr6+K+hhjEil6Do0BFKUT50IMNwalMlhL5g0634zcUqYZx1BNF+c3NTeNzYbJgOyTCEo=";
    private static final String PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA+TWzUflAOqz7cFOCe06IECO3Jq6kV5rPrVhhUbKHc5xqUr2ruW69UXCz3EOjFXhWf/Ubr2ysDexxV8lLP5kP9buk3Bvz+caepRR5K5DlBh8oF11AwlcGTSVetMrzm4nyDHVCq2pF7NeF/J/sFZr+tlU/xnI6blq+ZTlIIVubRkmsUttFQamX3L9ACUukaanHv9AFrTwPtzCb1wSULJCEgo32UKK2pBh5I0XxL8JoBP/PuBDSsVp/sysh9bPdptPGRE5DgqTQAk+rz25+1xTtlWyIIhpMCHpJXlIdDqVq8x9d3NsLGpVH7FYXiLiPil07h/KkPAM3pnUQUTQ7SI6YmQIDAQAB";

    public static KeyPair generateKeyPair() {
        return RSAUtils.generateKeyPair(2048);
    }

    public static KeyPair generateKeyPair(int keySize) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
            keyPairGenerator.initialize(keySize);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Failed to generate key pair!", e);
        }
    }

    public static PublicKey getPublicKey(String base64PublicKey) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)base64PublicKey));
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            return publicKey;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to get public key!", e);
        }
    }

    public static PublicKey getPublicKey(BigInteger modulus, BigInteger exponent) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, exponent);
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to get public key!", e);
        }
    }

    public static String getBase64PublicKey(PublicKey publicKey) {
        return Base64.encodeBase64String((byte[])publicKey.getEncoded());
    }

    public static PrivateKey getPrivateKey(String base64PrivateKey) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)base64PrivateKey));
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to get private key!", e);
        }
    }

    public static PrivateKey getPrivateKey(BigInteger modulus, BigInteger exponent) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(modulus, exponent);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to get private key!", e);
        }
    }

    public static String getBase64PrivateKey(PrivateKey privateKey) {
        return Base64.encodeBase64String((byte[])privateKey.getEncoded());
    }

    public static byte[] encryptAsByteArray(String data, PublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ECB_PKCS1_PADDING);
            cipher.init(1, publicKey);
            return cipher.doFinal(data.getBytes());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Encrypt failed!", e);
        }
    }

    public static byte[] encryptAsByteArray(String data, String base64PublicKey) {
        return RSAUtils.encryptAsByteArray(data, RSAUtils.getPublicKey(base64PublicKey));
    }

    public static String encryptAsString(String data, PublicKey publicKey) {
        return Base64.encodeBase64String((byte[])RSAUtils.encryptAsByteArray(data, publicKey));
    }

    public static String encryptAsString(String data, String base64PublicKey) {
        return Base64.encodeBase64String((byte[])RSAUtils.encryptAsByteArray(data, RSAUtils.getPublicKey(base64PublicKey)));
    }

    public static String decrypt(byte[] data, PrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ECB_PKCS1_PADDING);
            cipher.init(2, privateKey);
            return new String(cipher.doFinal(data));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Decrypt failed!", e);
        }
    }

    public static String decrypt(byte[] data, String base64PrivateKey) {
        return RSAUtils.decrypt(data, RSAUtils.getPrivateKey(base64PrivateKey));
    }

    public static String decrypt(String data, PrivateKey privateKey) {
        return RSAUtils.decrypt(Base64.decodeBase64((String)data), privateKey);
    }

    public static String decrypt(String data) {
        return RSAUtils.decrypt(Base64.decodeBase64((String)data), RSAUtils.getPrivateKey(PRIVATE_KEY));
    }
}

