/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.core.logs;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.saas.core.InjectResolverFactory;
import com.bcxin.saas.core.components.SessionProvider;
import com.bcxin.saas.core.logs.LoggerEventMessage;
import com.bcxin.saas.core.logs.LoggerProvider;
import com.bcxin.saas.core.utils.ExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class SysLogProvider {
    public static final String DEBUG_SESSION = "DEBUG_SESSION";
    private static Logger logger = LoggerFactory.getLogger(SysLogProvider.class);
    private static String LOG_SQL_QUERY_CONTENT_SELECT_TEMPLATE = "select ID,`TRACK_CATEGORY`,`TRACK_NAME`,`MESSAGE`,`TRACK_PARAMS` from logging_sys_apps x where x.TRACK_CATEGORY=?";
    private static String LOG_SQL_QUERY_CONTENT_DELETE_TEMPLATE = "delete from logging_sys_apps where TRACK_CATEGORY=?";
    private static DataSource dataSource;

    public static void log(String category, String name, ProcessedStatus status, String message, Object data) {
        LoggerProvider loggerProvider = InjectResolverFactory.resolve(LoggerProvider.class);
        if (loggerProvider == null) {
            return;
        }
        loggerProvider.append(LoggerEventMessage.create(category, name, message, data, Level.ERROR));
    }

    public static void log(Collection<LoggerEventMessage> loggerEventMessages) {
        if (loggerEventMessages == null || loggerEventMessages.size() == 0) {
            return;
        }
        LoggerProvider loggerProvider = InjectResolverFactory.resolve(LoggerProvider.class);
        if (loggerProvider == null) {
            System.err.println("\u65e0\u6cd5\u89e3\u6790loggerProvider Bean\u5bf9\u8c61");
            return;
        }
        loggerProvider.appends(loggerEventMessages);
    }

    public static Collection<LoggerEventMessage> getMessages(String categoryId) {
        ArrayList<LoggerEventMessage> result = new ArrayList<LoggerEventMessage>();
        Object sessionValue = InjectResolverFactory.resolve(SessionProvider.class).getAttribute(DEBUG_SESSION);
        if (sessionValue != null) {
            result.addAll((Collection)sessionValue);
        }
        return result;
    }

    public static void deleteMessages(String categoryId) {
        InjectResolverFactory.resolve(SessionProvider.class).setAttribute(DEBUG_SESSION, null);
    }

    public static void log(String category, String name, Exception ex) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("error", (Object)ExceptionUtils.getStackMessage(ex));
        SysLogProvider.log(category, name, ProcessedStatus.Error, ex.getMessage(), jsonObject);
    }

    public static void setDataSource(DataSource dataSource) {
        SysLogProvider.dataSource = dataSource;
    }

    public static enum ProcessedStatus {
        Initialize,
        Done,
        Processing,
        Error,
        Retry;

    }
}

