/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.core.components.dtos;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class DataPermissionScopeDTO
implements Serializable {
    private String id;
    private String searchIndexCode;
    private Collection<String> scopes;
    private boolean crossPermission;

    public static DataPermissionScopeDTO create(String id, String searchIndexCode, Collection<String> scopes, Collection<String> additionalScopes) {
        DataPermissionScopeDTO dataPermissionScopeDTO = new DataPermissionScopeDTO();
        dataPermissionScopeDTO.setId(id);
        HashSet<String> allowedScopes = new HashSet<String>();
        if (scopes != null && !scopes.isEmpty()) {
            allowedScopes.addAll(scopes);
        }
        if (!"*".equals(searchIndexCode)) {
            allowedScopes.add(id);
            allowedScopes.addAll(additionalScopes);
        }
        dataPermissionScopeDTO.setSearchIndexCode(searchIndexCode);
        dataPermissionScopeDTO.setScopes(allowedScopes);
        dataPermissionScopeDTO.setCrossPermission(allowedScopes.size() > 1);
        return dataPermissionScopeDTO;
    }

    public static DataPermissionScopeDTO createForAllPermissions(String id) {
        DataPermissionScopeDTO dataPermissionScopeDTO = new DataPermissionScopeDTO();
        dataPermissionScopeDTO.setId(id);
        dataPermissionScopeDTO.setSearchIndexCode("*");
        dataPermissionScopeDTO.setScopes(Collections.singletonList("*"));
        dataPermissionScopeDTO.setCrossPermission(true);
        return dataPermissionScopeDTO;
    }

    public static DataPermissionScopeDTO empty(String id) {
        DataPermissionScopeDTO dataPermissionScopeDTO = new DataPermissionScopeDTO();
        dataPermissionScopeDTO.setId(id);
        dataPermissionScopeDTO.setScopes(Collections.singleton(id));
        dataPermissionScopeDTO.setCrossPermission(false);
        return dataPermissionScopeDTO;
    }

    public String getId() {
        return this.id;
    }

    public String getSearchIndexCode() {
        return this.searchIndexCode;
    }

    public Collection<String> getScopes() {
        return this.scopes;
    }

    public boolean isCrossPermission() {
        return this.crossPermission;
    }

    private void setId(String id) {
        this.id = id;
    }

    private void setSearchIndexCode(String searchIndexCode) {
        this.searchIndexCode = searchIndexCode;
    }

    private void setScopes(Collection<String> scopes) {
        this.scopes = scopes;
    }

    private void setCrossPermission(boolean crossPermission) {
        this.crossPermission = crossPermission;
    }
}

