/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.core.components;

import com.alibaba.fastjson.JSON;
import com.bcxin.saas.core.exceptions.SaasBadException;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public interface JsonProvider {
    public <T> T getData(String var1, Class<T> var2);

    public <T> String getJson(T var1);

    public <T> Collection<T> getDataList(String var1, Class<T> var2);

    public static class JsonProviderImpl
    implements JsonProvider {
        @Override
        public <T> T getData(String json, Class<T> tClass) {
            if (StringUtils.isBlank((CharSequence)json)) {
                return null;
            }
            try {
                return (T)JSON.parseObject((String)json, tClass);
            }
            catch (Exception ex) {
                throw new SaasBadException("JSON\u53cd\u5e8f\u5217\u5316\u5f02\u5e38", ex);
            }
        }

        @Override
        public <T> String getJson(T data) {
            try {
                return JSON.toJSONString(data);
            }
            catch (Exception ex) {
                throw new SaasBadException("JSON\u5e8f\u5217\u5316\u5f02\u5e38", ex);
            }
        }

        @Override
        public <T> Collection<T> getDataList(String json, Class<T> tClass) {
            if (StringUtils.isEmpty((CharSequence)json)) {
                return Collections.EMPTY_LIST;
            }
            return JSON.parseArray((String)json, tClass);
        }
    }
}

