/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.core.components;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import java.util.Map;

public interface HttpRequestProvider {
    public HttpResponse post(String var1, Map<String, Object> var2, String var3);

    public HttpResponse get(String var1);

    public void download(String var1, String var2);

    public static class HttpRequestProviderImpl
    implements HttpRequestProvider {
        private final JsonProvider jsonProvider;

        public HttpRequestProviderImpl(JsonProvider jsonProvider) {
            this.jsonProvider = jsonProvider;
        }

        @Override
        public HttpResponse post(String url, Map<String, Object> headers, String data) {
            try {
                HttpRequest request = HttpRequest.post((String)url);
                if (headers != null) {
                    headers.forEach((key, value) -> request.header(key, String.valueOf(value)));
                }
                HttpResponse response = request.body(data).execute();
                return response;
            }
            catch (Exception ex) {
                throw new SaasBadException(ex.toString());
            }
        }

        @Override
        public HttpResponse get(String url) {
            return HttpRequest.get((String)url).execute();
        }

        @Override
        public void download(String url, String targetPath) {
            HttpUtil.downloadFile((String)url, (String)targetPath);
        }
    }
}

