/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.core.components;

import com.bcxin.saas.core.components.dtos.DataPermissionType;
import com.bcxin.saas.core.enums.EnvironmentType;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class DataPermissionScopeConfig {
    public static final String ALL_PERMISSIONS = "*";
    private final String dataScoped;
    private final Collection<String> conditionAppIds;
    private final EnvironmentType environmentType;

    public DataPermissionScopeConfig(String dataScoped, Collection<String> conditionAppIds, EnvironmentType environmentType) {
        this.dataScoped = dataScoped;
        this.environmentType = environmentType;
        this.conditionAppIds = conditionAppIds != null ? conditionAppIds : new HashSet<String>();
    }

    public boolean isAllowedAllData() {
        return (this.environmentType == EnvironmentType.Government_Inner || this.environmentType == EnvironmentType.Government_Network) && !StringUtils.isEmpty((CharSequence)this.dataScoped) && "all".equalsIgnoreCase(this.dataScoped);
    }

    public boolean isConditionLimitedApp(String appId) {
        return this.getConditionAppIds().stream().anyMatch(ii -> ii.equalsIgnoreCase(appId));
    }

    public static String getPermissionCacheKey(DataPermissionType permissionType, String id) {
        return String.format("com:scopes:pms:%s:%s", new Object[]{permissionType, id});
    }

    public static String getPermissionScopeCacheKey(DataPermissionType permissionType, String id) {
        return String.format("com:scopes:pms:%s:scope:%s", new Object[]{permissionType, id});
    }

    public String getDataScoped() {
        return this.dataScoped;
    }

    public Collection<String> getConditionAppIds() {
        return this.conditionAppIds;
    }

    public EnvironmentType getEnvironmentType() {
        return this.environmentType;
    }
}

