/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.core.components;

import com.bcxin.saas.core.components.EncryptProvider;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasForbidException;
import com.bcxin.saas.core.models.AppAclModel;
import java.util.Date;

public interface ClientAccessProvider {
    public String createToken(String var1, Date var2);

    public String getUserId(String var1);

    public static class ClientAccessProviderImpl
    implements ClientAccessProvider {
        private final JsonProvider jsonProvider;
        private final EncryptProvider encryptProvider;

        public ClientAccessProviderImpl(JsonProvider jsonProvider, EncryptProvider encryptProvider) {
            this.jsonProvider = jsonProvider;
            this.encryptProvider = encryptProvider;
        }

        @Override
        public String createToken(String userId, Date expiredTime) {
            AppAclModel appAclModel = AppAclModel.create(userId, expiredTime);
            String json = this.jsonProvider.getJson(appAclModel);
            return this.encryptProvider.encode(json);
        }

        @Override
        public String getUserId(String token) {
            try {
                String plainText = this.encryptProvider.decode(token);
                AppAclModel aclModel = this.jsonProvider.getData(plainText, AppAclModel.class);
                if (aclModel != null) {
                    return aclModel.getUserId();
                }
                return null;
            }
            catch (Exception ex) {
                throw new SaasForbidException(String.format("\u672a\u6388\u6743token(%s)\u65e0\u6548", token), ex);
            }
        }
    }
}

