/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.core.components;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public interface CacheProvider {
    public <T> T getData(String var1, Supplier<T> var2);

    public <T> T getData(String var1, Supplier<T> var2, int var3);

    public void reset(String var1);

    public <T> void update(String var1, T var2);

    public <T> void update(String var1, T var2, int var3);

    public static class CacheProviderImpl
    implements CacheProvider {
        private final int DEFAULT_EXPIRED_IN_SECONDS = 172800;
        private static ConcurrentHashMap<String, CacheDataWrapper> concurrentHashMap = new ConcurrentHashMap();

        @Override
        public <T> T getData(String key, Supplier<T> supplier) {
            return this.getData(key, supplier, 172800);
        }

        @Override
        public <T> T getData(String key, Supplier<T> supplier, int expiredInSeconds) {
            assert (supplier != null);
            CacheDataWrapper wrapperData = concurrentHashMap.get(key);
            Object data = null;
            if (wrapperData == null || wrapperData.isExpired()) {
                data = supplier.get();
                this.update(key, data);
            } else {
                data = wrapperData.getData();
            }
            return (T)data;
        }

        @Override
        public void reset(String key) {
            concurrentHashMap.remove(key);
        }

        @Override
        public <T> void update(String key, T data) {
            this.update(key, data, 172800);
        }

        @Override
        public <T> void update(String key, T data, int expiredInSeconds) {
            if (data == null) {
                if (concurrentHashMap.contains(key)) {
                    concurrentHashMap.remove(key);
                }
                return;
            }
            concurrentHashMap.put(key, CacheDataWrapper.create(data, expiredInSeconds));
        }

        public static class CacheDataWrapper {
            private final Object data;
            private final int expiredInSeconds;
            private final Timestamp expiredTimestamp;

            public CacheDataWrapper(Object data, int expiredInSeconds, Timestamp expiredTimestamp) {
                this.data = data;
                this.expiredInSeconds = expiredInSeconds;
                this.expiredTimestamp = expiredTimestamp;
            }

            public static CacheDataWrapper create(Object data, int expiredInSeconds) {
                return new CacheDataWrapper(data, expiredInSeconds, Timestamp.from(Instant.now().plusSeconds(expiredInSeconds)));
            }

            public boolean isExpired() {
                return Timestamp.from(Instant.now()).after(this.getExpiredTimestamp());
            }

            public Object getData() {
                return this.data;
            }

            public int getExpiredInSeconds() {
                return this.expiredInSeconds;
            }

            public Timestamp getExpiredTimestamp() {
                return this.expiredTimestamp;
            }
        }
    }
}

