/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.entities;

import com.bcxin.event.enums.EventAction;
import com.bcxin.saas.core.models.EntityBase;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="data_event_sources")
public class EventSourceEntity
extends EntityBase<String> {
    @Id
    @Column(length=50)
    private String id;
    @Column(nullable=false, length=50, name="record_id")
    private String recordId;
    @Column(name="meta_id", length=50, nullable=false)
    private String metaId;
    private String data;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_updated_time")
    private Date lastUpdatedTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", nullable=false)
    private Date createdTime;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="event_action", nullable=false)
    private EventAction eventAction;

    protected EventSourceEntity() {
    }

    public static EventSourceEntity create(EventAction eventAction, String recordId, String metaId, String data) {
        EventSourceEntity eventSourceEntity = new EventSourceEntity();
        eventSourceEntity.setEventAction(eventAction);
        eventSourceEntity.setData(data);
        eventSourceEntity.setMetaId(metaId);
        eventSourceEntity.setRecordId(recordId);
        eventSourceEntity.setCreatedTime(new Date());
        eventSourceEntity.setId(String.format("%s%s", new SimpleDateFormat("yyyyMMddhhmmss").format(new Date()), UUID.randomUUID().toString()));
        return eventSourceEntity;
    }

    public String getId() {
        return this.id;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public String getMetaId() {
        return this.metaId;
    }

    public String getData() {
        return this.data;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public EventAction getEventAction() {
        return this.eventAction;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setRecordId(String recordId) {
        this.recordId = recordId;
    }

    protected void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    protected void setData(String data) {
        this.data = data;
    }

    protected void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    protected void setEventAction(EventAction eventAction) {
        this.eventAction = eventAction;
    }
}

