/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.domain.repositories;

import com.bcxin.saas.core.enums.OrganizationLevel;
import com.bcxin.saas.domains.dtos.EmployeeContextInfoDTO;
import com.bcxin.saas.domains.dtos.OrgContextInfoDTO;
import com.bcxin.saas.domains.repositories.TenantDbReaderRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class TenantDbReaderRepositoryImpl
implements TenantDbReaderRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public TenantDbReaderRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public EmployeeContextInfoDTO getByEmployeeId(String id) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("employeeId", id);
        String sql = "SELECT ee.id as employeeId,o.id,o.industry_code,o.institutional_code,o.`level`,o.supervise_region_code FROM tenant_employees ee join tenant_organizations o on ee.organization_id=o.id\nwhere ee.id=:employeeId";
        return ((Collection)this.jdbcTemplate.query(sql, paramMap, resultSet -> {
            ArrayList<EmployeeContextInfoDTO> rt = new ArrayList<EmployeeContextInfoDTO>();
            while (resultSet.next()) {
                EmployeeContextInfoDTO info = new EmployeeContextInfoDTO();
                info.setEmployeeId(resultSet.getString("employeeId"));
                info.setId(resultSet.getString("id"));
                info.setIndustryCode(resultSet.getString("industry_code"));
                info.setInstitutionalCode(resultSet.getString("institutional_code"));
                info.setSuperviseRegionCode(resultSet.getString("supervise_region_code"));
                Collection selectedOrgLevels = OrganizationLevel.getSelectedOrganizationLevels((int)resultSet.getInt("level"));
                info.setOrganizationLevels(selectedOrgLevels);
                rt.add(info);
            }
            return rt;
        })).stream().findFirst().orElse(null);
    }

    public OrgContextInfoDTO getByOrgId(String orgId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("orgId", orgId);
        String sql = "SELECT o.id,o.industry_code,o.institutional_code,o.`level`,o.supervise_region_code FROM tenant_organizations o where o.id=:orgId";
        return ((Collection)this.jdbcTemplate.query(sql, paramMap, resultSet -> {
            ArrayList<OrgContextInfoDTO> rt = new ArrayList<OrgContextInfoDTO>();
            while (resultSet.next()) {
                OrgContextInfoDTO info = new OrgContextInfoDTO();
                info.setId(resultSet.getString("id"));
                info.setIndustryCode(resultSet.getString("industry_code"));
                info.setInstitutionalCode(resultSet.getString("institutional_code"));
                info.setSuperviseRegionCode(resultSet.getString("supervise_region_code"));
                Collection selectedOrgLevels = OrganizationLevel.getSelectedOrganizationLevels((int)resultSet.getInt("level"));
                info.setOrganizationLevels(selectedOrgLevels);
                rt.add(info);
            }
            return rt;
        })).stream().findFirst().orElse(null);
    }
}

