/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.domain.repositories;

import com.bcxin.saas.domains.dtos.RbacQueryDTO;
import com.bcxin.saas.domains.repositories.RbacOptionRepository;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class RbacOptionRepositoryImpl
implements RbacOptionRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public RbacOptionRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Set<String> findPermitOptions(RbacQueryDTO rbacQueryDTO) {
        String sql;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appCode", rbacQueryDTO.getAppId());
        paramMap.put("optionType", rbacQueryDTO.isMobile() ? 2 : 1);
        if (rbacQueryDTO.isDomainAdmin()) {
            sql = "select option_code from rbac_permit_option where app_code = :appCode and option_type = :optionType";
        } else {
            paramMap.put("tenantEmployeeId", rbacQueryDTO.getEmployeeId());
            sql = " SELECT p.option_code FROM rbac_custom_role_user u JOIN rbac_permit_option_role p ON p.rbac_role_id = u.rbac_role_id  WHERE u.tenant_employee_id = :tenantEmployeeId  AND p.app_code = :appCode  AND p.option_type = :optionType  UNION SELECT p1.option_code   FROM rbac_permit_option_user p1  WHERE p1.tenant_employee_id = :tenantEmployeeId  AND p1.app_code = :appCode  AND p1.option_type = :optionType";
        }
        List permitOptions = this.jdbcTemplate.queryForList(sql, paramMap, String.class);
        return new HashSet<String>(permitOptions);
    }
}

