/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.domain.repositories;

import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import com.bcxin.saas.domains.entities.DomainRelationEntity;
import com.bcxin.saas.domains.repositories.DomainRelationRepository;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class DomainRelationRepositoryImpl
implements DomainRelationRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public DomainRelationRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Collection<DomainRelationEntity> getByDomainId(String domainId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("domain_id", domainId);
        List maps = this.jdbcTemplate.queryForList("select * from saas_domain_relation where domain_id=:domain_id", param);
        return maps.stream().map(ii -> {
            DomainRelationEntity entity = new DomainRelationEntity();
            entity.setId((Integer)ii.get("id"));
            entity.setDomainId((String)ii.get("domain_id"));
            entity.setChildDomainId((String)ii.get("child_domain_id"));
            entity.setEnabled((Integer)ii.get("is_enabled") == 1);
            entity.setCreatedTime((Date)ii.get("created_time"));
            entity.setDomainId((String)ii.get("note"));
            return entity;
        }).collect(Collectors.toList());
    }

    public <S extends DomainRelationEntity> List<S> saveAll(Iterable<S> entities) {
        throw new SaasNoSupportException();
    }
}

