/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.domain.repositories;

import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import com.bcxin.saas.domains.entities.DepartmentEntity;
import com.bcxin.saas.domains.repositories.DepartmentRepository;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class DepartmentRepositoryImpl
implements DepartmentRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public DepartmentRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public DepartmentEntity getRootDepartmentByDomainId(String domainId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("domainId", domainId);
        return (DepartmentEntity)this.jdbcTemplate.queryForObject("select id,index_tree,name,parent_id,total_member from tenant_departments where organization_id=:domainId and status=1 and is_deleted=false and parent_id is null limit 1", paramMap, (RowMapper)new BeanPropertyRowMapper(DepartmentEntity.class));
    }

    public Collection<DepartmentEntity> getDepartmentByParentId(String parentId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("parentId", parentId);
        return this.jdbcTemplate.query("select id,index_tree,name,parent_id,total_member from tenant_departments where parent_id=:parentId and status=1 and is_deleted=false", paramMap, (RowMapper)new BeanPropertyRowMapper(DepartmentEntity.class));
    }

    public Collection<DepartmentEntity> getAllDepartmentByParentId(String parentId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("parentId", parentId);
        return this.jdbcTemplate.query("select id,index_tree,name,parent_id,total_member from tenant_departments where index_tree like':parentId-%' and status=1 and is_deleted=false", paramMap, (RowMapper)new BeanPropertyRowMapper(DepartmentEntity.class));
    }

    public <S extends DepartmentEntity> List<S> saveAll(Iterable<S> entities) {
        throw new SaasNoSupportException();
    }
}

