/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.web.commons.components;

import com.bcxin.saas.core.components.CaptchaCodeProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.utils.Base64Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;
import org.springframework.stereotype.Component;

@Component
public class DefaultCaptchaCodeProviderImpl
implements CaptchaCodeProvider {
    private static int WIDTH = 60;
    private static int HEIGHT = 20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CaptchaCodeProvider.CaptchaResult getBase64String() {
        BufferedImage image = new BufferedImage(WIDTH + 6, HEIGHT + 4, 1);
        Graphics g = null;
        char[] rands = null;
        try {
            g = image.getGraphics();
            rands = this.generateCheckCode();
            this.drawBackground(g);
            this.drawRands(g, rands);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "JPG", baos);
            byte[] bytes = baos.toByteArray();
            String png_base64 = Base64Util.encode((byte[])bytes);
            png_base64 = png_base64.replaceAll("\n", "").replaceAll("\r", "");
            CaptchaCodeProvider.CaptchaResult captchaResult = CaptchaCodeProvider.CaptchaResult.create((String)String.format("data:image/jpg;base64,%s", png_base64), (String)String.valueOf(rands));
            return captchaResult;
        }
        catch (IOException ex) {
            throw new SaasBadException("\u9a8c\u8bc1\u7801\u751f\u6210\u5931\u8d25", (Exception)ex);
        }
    }

    private char[] generateCheckCode() {
        String chars = "0123456789abcdefghijkLmnopqrstuvwxyz";
        char[] rands = new char[4];
        for (int i = 0; i < 4; ++i) {
            int rand = new Random().nextInt(36);
            rands[i] = chars.charAt(rand);
        }
        return rands;
    }

    private void drawBackground(Graphics gd) {
        Random r = new Random();
        gd.setColor(Color.black);
        gd.clipRect(0, 0, WIDTH + 6, HEIGHT + 4);
        gd.setColor(Color.white);
        gd.fillRect(1, 1, WIDTH + 4, HEIGHT + 2);
        for (int i = 0; i < 30; ++i) {
            int x = r.nextInt(WIDTH) + 2;
            int y = r.nextInt(HEIGHT) + 3;
            int xl = r.nextInt(12);
            int yl = r.nextInt(12);
            int red = r.nextInt(255);
            int green = r.nextInt(255);
            int blue = r.nextInt(255);
            gd.setColor(new Color(red, green, blue));
            gd.drawLine(x, y, x + xl, y + yl);
        }
    }

    private void drawRands(Graphics g, char[] rands) {
        g.setColor(new Color(0x1F1F1F));
        Font font = new Font("Fixedsys", 0, HEIGHT);
        g.setFont(font);
        int xx = WIDTH / (rands.length + 1);
        int codeY = HEIGHT;
        for (int i = 0; i < rands.length; ++i) {
            g.drawString("" + rands[i], (i + 1) * xx, codeY);
        }
    }
}

