/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.web.commons;

import com.bcxin.saas.core.utils.ComponentUtils;
import com.bcxin.web.commons.RequestHandlerInterceptor;
import com.bcxin.web.commons.filters.BasicWebFilter;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;

@Configuration(value="com.bcxin.web.commons.SetupConfig")
@ComponentScan(basePackages={"com.bcxin.web.commons"})
public class SetupConfig
implements WebMvcConfigurer {
    @Bean
    public RequestContextListener requestContextListener() {
        return new RequestContextListener();
    }

    @Bean
    public RequestHandlerInterceptor requestHandlerInterceptor() {
        return new RequestHandlerInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        super.addInterceptors(registry);
        registry.addInterceptor((HandlerInterceptor)this.requestHandlerInterceptor()).addPathPatterns(new String[]{"/api/runtime/**", "/api/runtime-ex/**"});
    }

    @Bean
    public FilterRegistrationBean<BasicWebFilter> registerBasicWebFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new BasicWebFilter());
        bean.setName("BasicWebFilter");
        bean.addUrlPatterns(new String[]{"/*"});
        bean.addInitParameter("exclusions", ComponentUtils.getExclusions());
        bean.setOrder(1);
        return bean;
    }

    @Bean
    public RedissonClient redissonClient(RedisProperties redisProperties) {
        Config config = new Config();
        SingleServerConfig singleServerConfig = config.useSingleServer();
        singleServerConfig.setAddress(String.format("redis://%s:%s", redisProperties.getHost(), redisProperties.getPort()));
        singleServerConfig.setPassword(redisProperties.getPassword());
        singleServerConfig.setConnectionPoolSize(10000);
        singleServerConfig.setPingConnectionInterval(10000);
        RedissonClient redissonClient = Redisson.create((Config)config);
        return redissonClient;
    }

    @Bean
    public WebMvcRegistrations webMvcRegistrations() {
        return new WebMvcRegistrations(){

            public ExceptionHandlerExceptionResolver getExceptionHandlerExceptionResolver() {
                return new ExceptionHandlerExceptionResolver(){

                    protected ModelAndView doResolveHandlerMethodException(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, Exception exception) {
                        return super.doResolveHandlerMethodException(request, response, handlerMethod, exception);
                    }
                };
            }
        };
    }
}

