/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EventEntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.enums.EventProcessedStatus;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import org.springframework.util.StringUtils;

@Table(name="tenant_events")
@Entity
public class TenantEventEntity
extends EventEntityAbstract
implements IAggregate,
Comparable<TenantEventEntity> {
    @Id
    private String id;
    @Column(length=5000)
    private String content;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(nullable=false, name="event_action")
    private EventAction eventAction;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(nullable=false, name="status")
    private EventProcessedStatus status;
    @Column(length=5000)
    private String result;
    @Column(name="keyword", nullable=false, length=200)
    private String keyword;
    @Column(name="last_processed_time")
    private Timestamp lastProcessedTime;

    protected TenantEventEntity() {
    }

    public static TenantEventEntity create(EventAction eventAction, String keyword, String content) {
        TenantEventEntity tenantEvent = new TenantEventEntity();
        tenantEvent.setId(String.format("%s-%s", DateUtil.format2ShortDateTime((Date)tenantEvent.getCreatedTime()), UUIDUtil.getShortUuid()));
        tenantEvent.setStatus(EventProcessedStatus.Init);
        tenantEvent.setEventAction(eventAction);
        tenantEvent.setContent(content);
        tenantEvent.setKeyword(keyword);
        tenantEvent.setMapKey(eventAction.name());
        return tenantEvent;
    }

    public void done(String result) {
        this.setStatus(EventProcessedStatus.Processed);
        this.setResult(String.format("%s-%s", this.getResult(), result));
        if (this.getResult().length() > 2000) {
            this.setResult(result);
        }
        this.setLastProcessedTime(Timestamp.from(Instant.now()));
    }

    public void error(String result) {
        if (this.getEventAction() == EventAction.TenantUserAfterCreatedEventForSms && StringUtils.hasLength((String)result) && result.contains("\u4e0d\u6b63\u786e")) {
            this.setStatus(EventProcessedStatus.FailedAndIgnored);
        } else {
            this.setStatus(EventProcessedStatus.Failed);
        }
        this.setResult(result);
        this.setLastProcessedTime(Timestamp.from(Instant.now()));
    }

    @Override
    public int compareTo(TenantEventEntity o) {
        if (o == null) {
            return 1;
        }
        return (int)(this.getVersion() - o.getVersion());
    }

    public String getId() {
        return this.id;
    }

    public String getContent() {
        return this.content;
    }

    public EventAction getEventAction() {
        return this.eventAction;
    }

    public EventProcessedStatus getStatus() {
        return this.status;
    }

    public String getResult() {
        return this.result;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Timestamp getLastProcessedTime() {
        return this.lastProcessedTime;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setContent(String content) {
        this.content = content;
    }

    protected void setEventAction(EventAction eventAction) {
        this.eventAction = eventAction;
    }

    protected void setStatus(EventProcessedStatus status) {
        this.status = status;
    }

    protected void setResult(String result) {
        this.result = result;
    }

    protected void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    protected void setLastProcessedTime(Timestamp lastProcessedTime) {
        this.lastProcessedTime = lastProcessedTime;
    }
}

