/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.enums.CerType;
import com.bcxin.Infrastructures.enums.GradeLevel;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Table(name="tenant_user_credential_details")
@Entity
public class TenantUserCredentialDetailsEntity {
    @Id
    private String id;
    @Column(name="active")
    private Boolean active;
    @Column(name="areacode")
    private String areaCode;
    @Column(name="xm", length=50, nullable=false)
    private String name;
    @Column(name="certificatetype", nullable=false)
    private String certificateType;
    @Column(name="fzrq")
    private Date cerDate;
    @Transient
    private CerType cerType;
    @Column(name="appraisalgrade", nullable=false)
    private String appraisalGrade;
    @Transient
    private GradeLevel gradeLevel;
    @Column(name="zsbh")
    private String cerNo;
    @Column(name="fzjgmc")
    private String orgName;
    @Column(name="tenant_user_id")
    private String tenantUserId;
    @Column(name="idnum")
    private String idnum;
    @Column(name="state")
    private String state;

    public CerType getCerType() {
        if (StrUtil.isNotEmpty((CharSequence)this.certificateType)) {
            return CerType.coventTypeValue((String)this.certificateType);
        }
        return null;
    }

    public GradeLevel getGradeLevel() {
        if (StrUtil.isNotEmpty((CharSequence)this.appraisalGrade)) {
            return GradeLevel.coventTypeValue((String)this.appraisalGrade);
        }
        return null;
    }

    public String getCerTypeName() {
        CerType cerType = this.getCerType();
        if (cerType != null) {
            GradeLevel gradeLevel;
            if (cerType.equals((Object)CerType.Grade) && (gradeLevel = this.getGradeLevel()) != null) {
                return cerType.getTypeName() + "-" + gradeLevel.getTypeName();
            }
            return cerType.getTypeName();
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getActive() {
        return this.active;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public String getName() {
        return this.name;
    }

    public String getCertificateType() {
        return this.certificateType;
    }

    public Date getCerDate() {
        return this.cerDate;
    }

    public String getAppraisalGrade() {
        return this.appraisalGrade;
    }

    public String getCerNo() {
        return this.cerNo;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getTenantUserId() {
        return this.tenantUserId;
    }

    public String getIdnum() {
        return this.idnum;
    }

    public String getState() {
        return this.state;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setActive(Boolean active) {
        this.active = active;
    }

    protected void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setCertificateType(String certificateType) {
        this.certificateType = certificateType;
    }

    protected void setCerDate(Date cerDate) {
        this.cerDate = cerDate;
    }

    protected void setCerType(CerType cerType) {
        this.cerType = cerType;
    }

    protected void setAppraisalGrade(String appraisalGrade) {
        this.appraisalGrade = appraisalGrade;
    }

    protected void setGradeLevel(GradeLevel gradeLevel) {
        this.gradeLevel = gradeLevel;
    }

    protected void setCerNo(String cerNo) {
        this.cerNo = cerNo;
    }

    protected void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    protected void setTenantUserId(String tenantUserId) {
        this.tenantUserId = tenantUserId;
    }

    protected void setIdnum(String idnum) {
        this.idnum = idnum;
    }

    protected void setState(String state) {
        this.state = state;
    }
}

