/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OpEntityAbstract;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.enums.EmployeeEventType;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Table(name="tenant_employee_events")
@Entity
public class EmployeeEventEntity
extends OpEntityAbstract
implements IAggregate {
    @Id
    private String id;
    @Column(name="event_type", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private EmployeeEventType eventType;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @ManyToOne(cascade={CascadeType.DETACH})
    @JoinColumn(name="employee_id", referencedColumnName="id", nullable=false)
    private EmployeeEntity employee;
    @Column(name="note", length=2000)
    private String note;
    @Column(name="attachment", length=2000)
    private String attachment;
    @Column(name="event_time", nullable=false)
    private Timestamp eventTime;
    @Enumerated(value=EnumType.ORDINAL)
    private ApprovedStatus status;
    @Column(name="approved_note", length=2000)
    private String approvedNote;
    @Column(name="approved_time", nullable=true)
    private Timestamp approvedTime;

    protected EmployeeEventEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static EmployeeEventEntity create(EmployeeEntity employee, EmployeeEventType eventType, Timestamp eventTime, String note) {
        EmployeeEventEntity employeeEvent = new EmployeeEventEntity();
        employeeEvent.setEmployee(employee);
        employeeEvent.setId(String.format("%s-%s", Instant.now().getEpochSecond(), UUIDUtil.getShortUuid()));
        employeeEvent.setEventType(eventType);
        employeeEvent.setEventTime(eventTime);
        employeeEvent.setNote(note);
        return employeeEvent;
    }

    public void changeStatus(ApprovedStatus status, String approvedNote) {
        this.setStatus(status);
        this.setApprovedNote(approvedNote);
        this.setApprovedTime(Timestamp.from(Instant.now()));
    }

    public void change(String note, String attachment) {
        this.setNote(note);
        this.setAttachment(attachment);
    }

    public void changeEventTime(Timestamp date) {
        this.setEventTime(date);
    }

    public String getId() {
        return this.id;
    }

    public EmployeeEventType getEventType() {
        return this.eventType;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public EmployeeEntity getEmployee() {
        return this.employee;
    }

    public String getNote() {
        return this.note;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public Timestamp getEventTime() {
        return this.eventTime;
    }

    public ApprovedStatus getStatus() {
        return this.status;
    }

    public String getApprovedNote() {
        return this.approvedNote;
    }

    public Timestamp getApprovedTime() {
        return this.approvedTime;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setEventType(EmployeeEventType eventType) {
        this.eventType = eventType;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setEmployee(EmployeeEntity employee) {
        this.employee = employee;
    }

    protected void setNote(String note) {
        this.note = note;
    }

    protected void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    protected void setEventTime(Timestamp eventTime) {
        this.eventTime = eventTime;
    }

    protected void setStatus(ApprovedStatus status) {
        this.status = status;
    }

    protected void setApprovedNote(String approvedNote) {
        this.approvedNote = approvedNote;
    }

    protected void setApprovedTime(Timestamp approvedTime) {
        this.approvedTime = approvedTime;
    }
}

