/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.MasterSlaveType;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.events.JoinDepartmentEvent;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Table(name="tenant_department_employee_relations", uniqueConstraints={@UniqueConstraint(name="unique_department_employee_relation_department_id_employee_id", columnNames={"department_id", "employee_id"})})
@Entity
public class DepartmentEmployeeRelationEntity
extends EntityAbstract
implements IAggregate {
    @Id
    @Column(length=100)
    private String id;
    @Column(name="master_slave_type", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private MasterSlaveType masterSlaveType;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH})
    @JoinColumn(name="department_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_department_employee_department_id", value=ConstraintMode.CONSTRAINT))
    private DepartmentEntity department;
    @Column(name="department_index_tree")
    private String departmentIndexTree;
    @Column(name="leader_type")
    private Boolean leaderType;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=EmployeeEntity.class, cascade={CascadeType.DETACH})
    @OrderColumn
    @JoinColumn(name="employee_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_department_employee_employee_id", value=ConstraintMode.NO_CONSTRAINT))
    private EmployeeEntity employee;

    public void gotoDepartment(DepartmentEntity destDepartment) {
        DepartmentEntity originalDepart = this.getDepartment();
        if (originalDepart.getId().equals(destDepartment.getId())) {
            return;
        }
        originalDepart.declEmployee();
        this.getEmployee().markDefaultDepartment(destDepartment);
        this.setDepartment(destDepartment);
        this.setDepartmentIndexTree(destDepartment.getIndexTree());
        destDepartment.incrEmployee();
        this.setMasterSlaveType(MasterSlaveType.Normal);
    }

    protected DepartmentEmployeeRelationEntity() {
    }

    public static DepartmentEmployeeRelationEntity create(DepartmentEntity department, EmployeeEntity employee, MasterSlaveType slaveType, boolean isNewEmployee) {
        DepartmentEmployeeRelationEntity departmentEmployeeRelation = new DepartmentEmployeeRelationEntity();
        departmentEmployeeRelation.setId(UUIDUtil.getShortUuid());
        departmentEmployeeRelation.setEmployee(employee);
        departmentEmployeeRelation.setDepartment(department);
        departmentEmployeeRelation.setDepartmentIndexTree(department.getIndexTree());
        departmentEmployeeRelation.setCreatedTime(Timestamp.from(Instant.now()));
        departmentEmployeeRelation.setMasterSlaveType(slaveType);
        if (!isNewEmployee) {
            departmentEmployeeRelation.recordEvent(JoinDepartmentEvent.create(employee.getOrganization().getId(), employee.getId(), department.getId()));
        }
        return departmentEmployeeRelation;
    }

    public String getId() {
        return this.id;
    }

    public MasterSlaveType getMasterSlaveType() {
        return this.masterSlaveType;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public DepartmentEntity getDepartment() {
        return this.department;
    }

    public String getDepartmentIndexTree() {
        return this.departmentIndexTree;
    }

    public Boolean getLeaderType() {
        return this.leaderType;
    }

    public EmployeeEntity getEmployee() {
        return this.employee;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setMasterSlaveType(MasterSlaveType masterSlaveType) {
        this.masterSlaveType = masterSlaveType;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setDepartment(DepartmentEntity department) {
        this.department = department;
    }

    protected void setDepartmentIndexTree(String departmentIndexTree) {
        this.departmentIndexTree = departmentIndexTree;
    }

    protected void setLeaderType(Boolean leaderType) {
        this.leaderType = leaderType;
    }

    protected void setEmployee(EmployeeEntity employee) {
        this.employee = employee;
    }
}

