package com.bcxin.tenant.domain.services.commands.externalMembers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.entities.TenantUserEntity;
import lombok.Getter;

@Getter
public class CreateOrgExternalMemberCommand extends CommandAbstract {
    private final OrganizationEntity organization;

    private final TenantUserEntity tenantUser;

    public CreateOrgExternalMemberCommand(OrganizationEntity organization, TenantUserEntity tenantUser) {
        this.organization = organization;
        this.tenantUser = tenantUser;
    }


    public static CreateOrgExternalMemberCommand create(OrganizationEntity organization, TenantUserEntity tenantUser)
    {
        return new CreateOrgExternalMemberCommand(organization,tenantUser);
    }
}
