package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import lombok.Getter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.Date;
import java.util.List;

@Getter
public class BatchLeaveEmployeeCommand extends CommandAbstract {
    private final Collection<String> ids;
    private final String organizationId;
    private final Date expectedDate;
    private final String note;

    public BatchLeaveEmployeeCommand(Collection<String> ids, String organizationId, Date expectedDate, String note) {
        this.ids = ids;
        this.organizationId = organizationId;
        this.expectedDate = expectedDate;
        this.note = note;
    }

    @Override
    public void validate() {
        super.validate();

        if (!StringUtils.hasLength(this.getOrganizationId())) {
            throw new BadTenantException("组织id不能为空");
        }

        if (CollectionUtils.isEmpty(this.getIds())) {
            throw new BadTenantException("职员ids不能为空");
        }

        if (this.getExpectedDate() == null) {
            throw new BadTenantException("离职日期不能为空");
        }

        if (!StringUtils.hasLength(this.getNote())) {
            throw new BadTenantException("离职原因不能为空");
        }

        if(!DateUtil.format2ShortDate().equals(DateUtil.format2ShortDate(this.getExpectedDate()))){
            throw new BadTenantException("离职日期必须是当天");
        }
    }

    public static BatchLeaveEmployeeCommand create(Collection<String> ids, String organizationId, Date expectedDate, String note) {
        return new BatchLeaveEmployeeCommand(ids, organizationId, expectedDate, note);
    }
}
