package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import lombok.Getter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;

@Getter
public class BatchCreateDepartAdminCommand extends CommandAbstract {
    private final String organizationId;
    private final Collection<String> employeeIds;
    private final Collection<String> departIds;

    public BatchCreateDepartAdminCommand(String organizationId,
                                         Collection<String> employeeIds,
                                         Collection<String> departIds) {
        this.organizationId = organizationId;
        this.employeeIds = employeeIds;
        this.departIds = departIds;
    }

    @Override
    public void validate() {
        /*
        if(!TenantContext.getInstance().getUserContext().isDomainAdmin()) {
            throw new NotAllowedTenantException("非组织管理员不允许执行该操作");
        }
         */

        if (!StringUtils.hasLength(this.getOrganizationId())) {
            throw new ArgumentTenantException("操作的企业无效!");
        }

        if (CollectionUtils.isEmpty(this.getEmployeeIds()) || this.getEmployeeIds().stream().anyMatch(ii -> !StringUtils.hasLength(ii))) {
            throw new ArgumentTenantException("职员信息无效!");
        }

        if (CollectionUtils.isEmpty(this.getDepartIds()) || this.getDepartIds().stream().anyMatch(ii -> !StringUtils.hasLength(ii))) {
            throw new ArgumentTenantException("部门信息无效!");
        }
    }

    public static BatchCreateDepartAdminCommand create(String organizationId,
                                                       Collection<String> employeeIds,
                                                       Collection<String> departIds) {
        return new BatchCreateDepartAdminCommand(organizationId, employeeIds, departIds);
    }
}
